/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef _MESSAGE_CAT_

#include <stdio.h>
#include "encode.h"

#define MSG_NUM		14

static char	**Message_List;
static int 	nLocaleID;

char *OptionAux_Message_CN[MSG_NUM] = {
	"输入法选项设置",	/* IME Options Setting*/
	"已选输入法:",	/* Selected input methods: */
	"输入法选项:",	/* IME Options: */
	"确定",		/* OK */
	"应用",		/* Apply */
	"重设",		/* Reset */
	"取消",		/* Cancel */
	NULL
};

char *OptionAux_Message_TW[MSG_NUM] = {
	"輸入法選項設置",	/* IME Options Setting */
	"已選輸入法:",	/* Selected input methods: */
	"輸入法選項:",	/* IME Options: */
	"確定",		/* OK */
	"應用",		/* Apply */
	"重設",		/* Reset */
	"取消",		/* Cancel */
	NULL
};

int Msg_Init(char *locale_name)
{
	int nLangID;

	nLangID = get_langid_from_locale(locale_name);
	nLocaleID = get_encodeid_from_locale(locale_name);
	
	Message_List = OptionAux_Message_CN;
	if (nLangID == LANG_ZH_CN)
		Message_List = OptionAux_Message_CN;
	else if (nLangID == LANG_ZH_TW || nLangID == LANG_ZH_HK)
		Message_List = OptionAux_Message_TW;
}

char *get_msg_by_msgid(int msg_id, char *default_msg)
{
	char buffer[256], *tmp_buf, *msg;
	int ilen, olen, ret;

	if (msg_id < 0 || msg_id >= MSG_NUM) 
		return((char *)strdup(default_msg));

	msg = Message_List[msg_id];
	tmp_buf = buffer;
	ilen = strlen(msg);
	olen = 256;
	memset(buffer, 0, olen);
	ret = Convert_UTF8_To_Native(nLocaleID, msg, ilen, &tmp_buf, &olen);
	if (ret == 0)
		return((char *)strdup(buffer));
	else
		return((char *)strdup(default_msg));
}

void Msg_Done()
{
}

#else

#include <nl_types.h>

#define MSG_FILE_NAME	"auxwin.cat"

nl_catd gCatd = (nl_catd) -1;
static  int 	nLocaleID;

int Msg_Init(char *locale_name)
{
	char file_name[128], *lang_name;

	if (!locale_name || !*locale_name) return(-1);

	nLocaleID = get_encodeid_from_locale(locale_name);
	lang_name = get_langname_from_locale(locale_name);
	sprintf(file_name, "/usr/lib/im/locale/%s/common/%s", lang_name, MSG_FILE_NAME);
	gCatd = catopen(file_name, 0);
	if (gCatd == (nl_catd)-1)
		printf("WARNING: Could not open message catalog: %s\n", name);
}

char *get_msg_by_msgid(int msg_id, char *default_msg)
{
	char buffer[256], *tmp_buf, *msg;
	int ilen, olen, ret;

	msg = (char *)catgets(gCatd, 1, msg_id, default_msg);

	tmp_buf = buffer;
	ilen = strlen(msg);
	olen = 256;
	memset(buffer, 0, olen);
	ret = Convert_UTF8_To_Native(nLocaleID, msg, ilen, &tmp_buf, &olen);
	if (ret == 0)
		return((char *)strdup(buffer));
	else
		return((char *)strdup(default_msg));
}

void Msg_Done()
{
	if (gCatd != (nl_catd)-1)
		catclose(gCatd);
}

#endif
