/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include "SunIM.h"
#include "hzinput.h"
#include "encode.h"

int encode_to_unicode(int encode, unsigned char *from, int from_len,
				  UTFCHAR *to, int to_len)
{
	int to_left, ret;
	char *to_ptr;

	DEBUG_printf("encode_to_unicode: from:%s, encode:%d\n", from, encode);
	to_left = to_len;
	ret = Convert_Native_To_UTF16(encode, from, from_len, (char **)&to, (size_t *)&to_left);
	DEBUG_printf("encode_to_unicode: return:%d, to_left:%d\n", ret, to_left);
	if (ret == -1) {
		to[0] = (UTFCHAR)0;
	} else {
		if (to_left > 2) {
			to_ptr = (char *)to;
			to_ptr[to_len - to_left] = 0;
			to_ptr[to_len - to_left +1] = 0;
		}
	}
	return(ret);
}

void encode_draw_preedit(iml_session_t *s, int encode, unsigned char *preedit_buf, int caret)
{
	static UTFCHAR Preedit_Buffer[MAX_PREEDIT_CHAR_NUM * 2];
	int preedit_len, caret_pos;
	int ret;
	
	preedit_len = strlen((char *)preedit_buf);
	if (preedit_len <=0)
		iml_preedit_enddraw(s);

	ret = encode_to_unicode(encode, preedit_buf, preedit_len, Preedit_Buffer, MAX_PREEDIT_CHAR_NUM * 2);
	if (ret != -1) {
		iml_preedit_draw(s, Preedit_Buffer, caret);
	}
}

void encode_draw_status(iml_session_t *s, int encode, unsigned char *status_buf)
{
	static UTFCHAR Status_Buffer[MAX_STATUS_CHAR_NUM * 2];
	int status_len;
	int ret;

	status_len = strlen((char *)status_buf);
	if (status_len <= 0)
		return;

	ret = encode_to_unicode(encode, status_buf, status_len, Status_Buffer, MAX_STATUS_CHAR_NUM * 2);
	if (ret != -1) {
		iml_status_draw(s, Status_Buffer);
	}
}

void encode_draw_candidates(iml_session_t *s, int encode, unsigned char **lookup_buf, int lookup_num, int lookup_label_type)
{
	static UTFCHAR *Lookup_Buffer[MAX_CANDIDATES_NUM];
	static UTFCHAR Lookup_Items_Buffer[MAX_CANDIDATES_NUM][MAX_CANDIDATE_CHAR_NUM * 2];
	static int bLookupInited = 0;

	int i, lookup_len;
	int ret = 0;

	if (bLookupInited == 0) {
		bLookupInited = 1;
		for (i=0; i<MAX_CANDIDATES_NUM; i++)
			Lookup_Buffer[i] = Lookup_Items_Buffer[i];
	}

	if (lookup_num <= 0)
		iml_lookup_enddraw(s);

	/* Notes that Lookup_Buffer has point to Lookup_Items_Buffer */
	for (i=0; i<lookup_num; i++) {
		lookup_len = strlen((char *)lookup_buf[i]);
		ret = encode_to_unicode(encode, lookup_buf[i], lookup_len, Lookup_Items_Buffer[i], MAX_CANDIDATE_CHAR_NUM * 2);
		if (ret == -1) break;
	}

	if (ret != -1) {
/*
		iml_lookup_enddraw(s);
*/
		iml_lookup_draw(s, Lookup_Buffer, lookup_num, lookup_label_type);
	}
}

void encode_commit(iml_session_t *s, int encode, unsigned char *commit_buf)
{
	static UTFCHAR Commit_Buffer[MAX_COMMIT_CHAR_NUM * 2];
	int commit_len;
	int ret;

	commit_len = strlen((char *)commit_buf);
	if (commit_len <= 0)
		return;

	ret = encode_to_unicode(encode, commit_buf, commit_len, Commit_Buffer, MAX_COMMIT_CHAR_NUM * 2);
	if (ret != -1) {
		iml_commit(s, Commit_Buffer);
	}
}

