/*
 * Copyright (c) 1999 by Sun Microsystem, Inc.
 * All rights reserved.
 *
 * xaux_common.h
 */
#pragma ident	"@(#)xaux_common.h 1.7 99/11/29"

#ifndef	XAUX_COMMON_H
#define	XAUX_COMMON_H

#define	ME_SO	"xaux_so"
#define	ME_EXT	"xaux_ext"

#define	XAUX_SOWIN_SUFFIX	"_sowin"
#define	XAUX_EXTWIN_SUFFIX	"_extwin"
#define	XAUX_XS_SUFFIX		"_xs"
#define	XAUX_SX_SUFFIX		"_sx"

#define	XAUX_RETRYINT_EXTWIN	1
#define	XAUX_MAXRETRY_EXTWIN	10

#define	XAUX_MAXCLASSNAMELEN	255
#define	XAUX_MAXSUFFIXLEN	16

#define	SX_PROP_ATOM_AUX_NAME(prop)	(*((CARD32 *)((prop) + 0)))
#define	SX_PROP_TYPE(prop)		(*((CARD16 *)((prop) + 4)))
#define	SX_PROP_INDEX(prop)		(*((CARD16 *)((prop) + 6)))
#define	SX_PROP_IMID(prop)		(*((CARD16 *)((prop) + 8)))
#define	SX_PROP_ICID(prop)		(*((CARD16 *)((prop) + 10)))
#define	SX_SIZE_PROP_STARTDONE		12
#define	SX_PROP_SOWIN(prop)		(*((CARD32 *)((prop) + 12)))
#define	SX_PROP_CLIENTWIN(prop)		(*((CARD32 *)((prop) + 16)))
#define	SX_PROP_FOCUSWIN(prop)		(*((CARD32 *)((prop) + 20)))
#define	SX_PROP_POSX(prop)		(*((CARD16 *)((prop) + 24)))
#define	SX_PROP_POSY(prop)		(*((CARD16 *)((prop) + 26)))
#define	SX_PROP_INT_COUNT(prop)		(*((CARD16 *)((prop) + 28)))
#define	SX_PROP_STR_COUNT(prop)		(*((CARD16 *)((prop) + 30)))
#define SX_SIZE_PROP_HEADER_DRAW	32
#define	SX_PROP_INT_LIST(prop)		((CARD32 *)((prop) + 32))
#define	SX_PROP_STR_LIST(prop) \
	((unsigned char *)((prop) + 32) \
		+ SX_PROP_INT_COUNT((prop)) * 4)

#define	XS_PROP_ATOM_AUX_NAME(prop)	(*((CARD32 *)((prop) + 0)))
#define	XS_PROP_IMID(prop)		(*((CARD16 *)((prop) + 4)))
#define	XS_PROP_ICID(prop)		(*((CARD16 *)((prop) + 6)))
#define	XS_PROP_INT_COUNT(prop)		(*((CARD16 *)((prop) + 8)))
#define	XS_PROP_STR_COUNT(prop)		(*((CARD16 *)((prop) + 10)))
#define XS_SIZE_PROP_HEADER_SETVALUE	12
#define	XS_PROP_INT_LIST(prop)		((CARD32 *)((prop) + 12))
#define	XS_PROP_STR_LIST(prop) \
	((unsigned char *)((prop) + 12) \
		+ XS_PROP_INT_COUNT((prop)) * 4)

#define	XAUX_SX_NATOMS			64
#define	XAUX_XS_NATOMS			64

typedef struct xaux_class_struct {
	const char	*classname;	/* aux_name */
	int		index;		/* aux_index */
	const char	*extexec;	/* full path of aux_ext executable */
	Window		sowin;		/* aux.so's window */
	Window		extwin;		/* aux_ext's window */
	Atom		atom_classname;	/* "${CLASSNAME}" */
	Atom		atom_sowin;	/* "${CLASSNAME}_sowin" */
	Atom		atom_extwin;	/* "${CLASSNAME}_extwin" */
	Atom		atom_sx[XAUX_SX_NATOMS]; /* "${CLASSNAME}_sx */
	size_t		atom_sx_num;	/* size of atom_sx */
	size_t		atom_sx_idx;	/* next atom_sx to use */
	Atom		atom_xs[XAUX_XS_NATOMS]; /* "${CLASSNAME}_xs */
	size_t		atom_xs_num;	/* size of atom_xs */
	size_t		atom_xs_idx;	/* next atom_xs to use */
	const CARD16	*utfname;	/* UTF-16 version of classname */
} xaux_class_t;

static const int	padding[4] = {0, 3, 2, 1};

#endif	/* !XAUX_COMMON_H */
