#ifndef	XAUX_EXT_COMMON_H
#define	XAUX_EXT_COMMON_H
#include <X11/Xlib.h>
#include "xaux_common.h"

typedef enum aux_ext_data_type_enum {
	AUX_EXT_DATA_NONE = 0,
	AUX_EXT_DATA_START = 1,
	AUX_EXT_DATA_DRAW = 2,
	AUX_EXT_DATA_DONE = 3,
	AUX_EXT_DATA_SETVALUE = 4
} aux_ext_data_type_t;

typedef struct aux_ext_string_struct {
	int		length;
	unsigned char *	ptr;
} aux_ext_string_t;

typedef struct aux_ext_data_struct {
	aux_ext_data_type_t	type;
	int		im;
	int		ic;
	int		aux_index;
	int		aux_name_length;
	unsigned char *	aux_name;
	int		integer_count;
	int *		integer_list;
	int		string_count;
	aux_ext_string_t *	string_list;
	unsigned char *	string_ptr;
	Window		clientwin;
	Window		focuswin;
	XPoint		point;
} aux_ext_data_t;

extern Bool xaux_ext_init_classes(Display  *, xaux_class_t *, Window);
extern Bool xaux_ext_process_client_message(Display *, XClientMessageEvent *);

extern xaux_class_t xaux_class;
extern Bool xaux_ext_Start(xaux_class_t *, aux_ext_data_t *);
extern Bool xaux_ext_Draw(xaux_class_t *, aux_ext_data_t *);
extern Bool xaux_ext_Done(xaux_class_t *, aux_ext_data_t *);
extern Bool xaux_ext_SetValue(
	Display		*display,
	xaux_class_t	*xc,
	aux_ext_data_t	*aux_ext_data);

#endif	/* !XAUX_EXT_COMMON_H */

