use Irssi 20020300;
use Irssi::Irc;
use strict;

use vars qw($VERSION %IRSSI); 
$VERSION = "0.9";
%IRSSI = (
	authors 	=> "Maciek \'fahren\' Freudenheim",
	contact 	=> "fahren\@bochnia.pl", 
	name 		=> "Antyidler",
	description 	=> "Antyidler with random time",
	license 	=> "GNU GPLv2 or later",
	changed		=> "Fri Mar 15 15:09:42 CET 2002"
);

my $atimeout = Irssi::timeout_add(180000, 'antyidlesend', '');

sub antyidlesend {
	for my $server (Irssi::servers()) {
		$server->send_raw("PRIVMSG $server->{nick} :IDLE");
		Irssi::timeout_remove($atimeout);
		$atimeout = Irssi::timeout_add(int(rand(180)+1)*1000, 'antyidlesend', '');
	}
}

sub idle_ctcpmsg {
	my ($server, $data, $sender, $addr, $target) = @_;

	Irssi::signal_stop() if ($sender eq $target && $data eq "IDLE");
}

Irssi::signal_add("default ctcp msg", "idle_ctcpmsg");
