# Copyright (C) 02 October 2001  Author FoxMaSk <odemah@phpfr.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#============================================================================
# Irssi  v0.7.98.CVS 20011019
# This script link two channels from different network.
# Users on each two channels can exchange informations 
# without being on the two networks at the same time.
# You can see this script working on #phpfr on IRCNet & #phpfr_ircnet on EFNet
#
# To install it ; put the script in ~/.irssi/scripts and then 
# cd to autorun and make ln -s ../linkchan.pl .
#============================================================================
# TODO : 
# make a command that give a list of users of the other channel
# make a sleep btw each copy/paste to avoid a kick of the current connection
# by the other bot :)

use strict;
use Irssi;
use vars qw($VERSION %IRSSI);

$VERSION = "0.0.1";
%IRSSI = (
    authors => 'Foxmask',
    contact => 'odemah@phpfr.org ',
    name => 'LinkChan',
    description => 'Link several channel on serveral network to make a big channel on the same subject like linux operating system ; php language etc...',
    license => 'GNU GPL',
    url => 'http://team.gcu-squad.org/~odemah/'
);

my $channel1 = "#phpfr";
my $channel2 = "#phpfr_ircnet";
my $ircnet1 = "IRCNet";
my $ircnet2 = "EFNet";

sub event_privmsg {
	my ($server, $data, $nick, $address) = @_;
    my ($target, $text) = $data =~ /^(\S*)\s:(.*)/;
    if ($server->{tag} eq $ircnet1 and $target eq $channel1 ) {
        Irssi::command("/msg -$ircnet2 $channel2 $channel1:$nick $text");
    } elsif ($server->{tag} eq $ircnet2 and $target eq $channel2 ) {
        Irssi::command("/msg -$ircnet1 $channel1 $channel2:$nick $text");
    }
}

sub join_action {
    my ($server,$channel, $nick,$addr) = @_;
    if ($server->{tag} eq $ircnet1 and $channel eq $channel1 ) {
                Irssi::command("/msg -$ircnet2 $channel2 $nick [$addr] has joined $channel1");
    } elsif ($server->{tag} eq $ircnet2 and $channel eq $channel2 ) {
                Irssi::command("/msg -$ircnet1 $channel1 $nick [$addr] has joined $channel2");
    }
}

sub part_action {
    my ($server,$channel, $nick,$addr,$reason) = @_;
    if ($server->{tag} eq $ircnet1 and $channel eq $channel1 ) {
                Irssi::command("/msg -$ircnet2 $channel2 $nick has left $channel1 ($reason)");
    } elsif ($server->{tag} eq $ircnet2 and $channel eq $channel2 ) {
                Irssi::command("/msg -$ircnet1 $channel1 $nick has left $channel2 ($reason)");
    }
}

sub quit_action {
    my ($server,$nick,$addr,$reason) = @_;
    if ($server->{tag} eq $ircnet1 ) {
                Irssi::command("/msg -$ircnet2 $channel2 $nick has quit ($reason)");
    } elsif ($server->{tag} eq $ircnet2 ) {
                Irssi::command("/msg -$ircnet1 $channel1 $nick has quit ($reason)");
    }
}

sub topic_action {
    my ($server,$channel, $topic,$nick,$addr) = @_;
    if ($server->{tag} eq $ircnet1 and $channel eq $channel1 ) {
                Irssi::command("/msg -$ircnet2 $channel2 *topic $topic set by $nick ($addr)");
    } elsif ($server->{tag} eq $ircnet2 and $channel eq $channel2 ) {
                Irssi::command("/msg -$ircnet1 $channel1 *topic $topic set by $nick ($addr)");
    }
}

sub nick_action {
    my ($server,$newnick, $oldnick, $addr) = @_;
    if ($server->{tag} eq $ircnet1 ) {
                Irssi::command("/msg -$ircnet2 $channel2 $oldnick is known as $newnick");
    } elsif ($server->{tag} eq $ircnet2 ) {
                Irssi::command("/msg -$ircnet1 $channel1 $oldnick is know as $newnick"); 
    }
}

sub kick_action {
    my ($server,$channel, $nick,$kicker,$addr,$reason) = @_;
    if ($server->{tag} eq $ircnet1 and $channel eq $channel1 ) {
                Irssi::command("/msg -$ircnet2 $channel2 $kicker kick $nick ($reason)");
    } elsif ($server->{tag} eq $ircnet2 and $channel eq $channel2 ) {
                Irssi::command("/msg -$ircnet1 $channel1 $kicker kick $nick ($reason)");
    }
}

sub irc_action {
    my ($server,$args,$nick,$addr,$channel) = @_;
    Irssi::print("message irc action $server,$args,$nick,$addr,$channel");
    if ($server->{tag} eq $ircnet1 and $channel eq $channel1 ) {
            Irssi::command("/msg -$ircnet2 $channel2 * $nick $args");
    } elsif ($server->{tag} eq $ircnet2 and $channel eq $channel2 ) {
            Irssi::command("/msg -$ircnet1 $channel1 * $nick $args");
    }
}


Irssi::signal_add("message join" , "join_action"  );
Irssi::signal_add("message part" , "part_action"  );
Irssi::signal_add("message quit" , "quit_action"  );
Irssi::signal_add("message nick" , "nick_action"  );
Irssi::signal_add("message kick" , "kick_action"  );
Irssi::signal_add("message topic", "topic_action" );

Irssi::signal_add("event privmsg", "event_privmsg");

Irssi::signal_add("message irc action", "irc_action");
Irssi::print("LinkChan Loaded");
