/*
 irssi.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

static gchar *autoload_plugin;
static gboolean reload;

static gboolean sig_reload(void)
{
    reload = TRUE;
    return TRUE;
}

void noui_init(void)
{
    static struct poptOption options[] =
    {
	POPT_AUTOHELP
        { "load", 'l', POPT_ARG_STRING, &autoload_plugin, 0, "Plugin to load (default = bot)", "PLUGIN" },
        { NULL, '\0', 0, NULL }
    };

    autoload_plugin = NULL;
    args_register(options);

    /*FIXME:this is just to get list_() functions linked in! something weird.. */
    list_find(NULL, "");
    /*FIXME:and continuing this stupidity */
    level2bits("all");

    irssi_gui = IRSSI_GUI_NONE;
    mainloop_first_init();
    irc_base_init();
    irc_extra_init();
    //ui_common_init();
    mainloop_init();
    setup_init();

    //ui_common_finish_init();

    signal_add("reload", (SIGNAL_FUNC) sig_reload);
    signal_emit("irssi init finished", 0);
}

void noui_deinit(void)
{
    signal_remove("reload", (SIGNAL_FUNC) sig_reload);
    mainloop_deinit();
    ui_common_deinit();
    irc_extra_deinit();
    irc_base_deinit();
}

int main(int argc, char **argv)
{
#ifdef HAVE_SOCKS
    SOCKSinit(argv[0]);
#endif
    noui_init();
    args_execute(argc, argv);

    if (autoload_plugin == NULL)
	autoload_plugin = "bot";

    do
    {
        reload = FALSE;
        plugin_load(autoload_plugin, "");
        main_loop();
    }
    while (reload);
    noui_deinit();

    return 0;
}
