#ifndef __SERVER_REDIRECT_H
#define __SERVER_REDIRECT_H

typedef struct
{
    gint last; /* number of "last" events at the start of the events list */
    GList *events; /* gchar* list of events */
}
REDIRECT_CMD_REC;

typedef struct
{
    gchar *name; /* event name */

    gchar *arg; /* argument for event we are expecting or NULL */
    gint argpos; /* argument position */

    gint group; /* group of events this belongs to */
    gboolean last; /* if this event is received, remove all the events in this group */
}
REDIRECT_REC;

void server_redirect_init(SERVER_REC *server, gchar *command, gint last, ...);
void server_redirect_initv(SERVER_REC *server, gchar *command, gint last, GList *list);

/* ... = gchar *event, gchar *signal, gint argpos, ... */
void server_redirect_event(SERVER_REC *server, gchar *arg, gint last, ...);
gint server_redirect_single_event(SERVER_REC *server, gchar *arg, gboolean last, gint group, gchar *event, gchar *signal, gint argpos);
void server_redirect_default(SERVER_REC *server, gchar *command);
void server_redirect_remove_next(SERVER_REC *server, gchar *event, GList *item);
GList *server_redirect_getqueue(SERVER_REC *server, gchar *event, gchar *args);

void servers_redirect_init(void);
void servers_redirect_deinit(void);

#endif
