/*
 setup-servers.c : Irssi settings

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

void read_keyinfo(KEYINFO_REC *info, proplist_t prop)
{
    proplist_t pvalue;
    gint max, num;
    gchar *data, *key;

    g_return_if_fail(info != NULL);
    g_return_if_fail(prop != NULL);

    /* remove all old keys */
    while (info->keys != NULL)
	key_configure_remove(((KEY_REC *) info->keys->data)->key);

    /* add the new keys */
    max = PLGetNumberOfElements(prop);
    for (num = 0; num < max; num++)
    {
	pvalue = PLGetArrayElement(prop, num);

	data = config_get_str(pvalue, "data", NULL);
	key = config_get_str(pvalue, "key", NULL);

	if (key != NULL) key_configure_add(info->id, data, key);
    }
}

static gboolean sig_keyboard_read(void)
{
    proplist_t kprop, pkeyinfos, pkey, pvalue;
    KEYINFO_REC *info;
    gint max, num;

    kprop = config_get_prop(cprop, "keyboard");
    if (kprop == NULL) return TRUE;

    pkeyinfos = PLGetAllDictionaryKeys(kprop);
    max = pkeyinfos == NULL ? 0 : PLGetNumberOfElements(pkeyinfos);
    for (num = 0; num < max; num++)
    {
	/* get the key & value */
	pkey = PLGetArrayElement(pkeyinfos, num);
	pvalue = PLGetDictionaryEntry(kprop, pkey);
	if (pkey == NULL || pvalue == NULL) continue; /* hm?? */

	info = key_info_find(PLGetString(pkey));
	if (info != NULL)
	    read_keyinfo(info, pvalue);
    }

    return TRUE;
}

void setup_keyboard_init(void)
{
    signal_add("irssi init finished", (SIGNAL_FUNC) sig_keyboard_read);
    signal_add("plugin loaded", (SIGNAL_FUNC) sig_keyboard_read);
}

void setup_keyboard_deinit(void)
{
    signal_remove("irssi init finished", (SIGNAL_FUNC) sig_keyboard_read);
    signal_remove("plugin loaded", (SIGNAL_FUNC) sig_keyboard_read);
}
