#****************************************************************************
#*                              alu_test.inc
#*
#* Author: Matthew Ballance
#* Desc:   Implements a testing routine for the alu...
#****************************************************************************

source setup.inc

set OP_ADD 1
set OP_SUB 2
set OP_MUL 3
set OP_DIV 4
set OP_SHL 5
set OP_SHR 6
set OP_MOV 7
set OP_ACC 8


proc do_cycle {in_a in_b op} {
    put value alu_tb_stub.in_a $in_a
    put value alu_tb_stub.in_b $in_b
    put value alu_tb_stub.op   $op
    put value alu_tb_stub.valid %stb

    run 1000

    return [get value alu_tb_stub.out -dec]
}

create_seq stb 0 1 after 100 0 after 200

#**** Create a clock with period 100ps
put value alu_tb_stub.clk 0 1 after 50 repeat after 50


set err_cnt 0
for {set i 0} {$i < 10} {incr i} {
    set res [do_cycle $i [expr 10 - $i] $OP_MUL]

    regsub {'d} $res {} res

    if {$res != [expr $i * [expr 10 - $i]]} {
        ivi_puts "ERROR :: expecting [expr $i * [expr 10 - $i]] got $res"
	incr err_cnt
    }
    ivi_puts "Result of $i => $res"
}


if {$err_cnt > 0} {
    ivi_puts "FAIL: $err_cnt errors"
} else {
    ivi_puts "PASS: "
}

