/*****************************************************************************
 *                              Callback.cc
 * 
 * Author: Matthew Ballance
 * Desc:   
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *****************************************************************************/
#include "Callback.h"
#include "CallbackList.h"
#include "CallbackType.h"

/********************************************************************
 * Callback
 ********************************************************************/
Callback::Callback(Tcl_ObjCmdProc *cbFunc, voidPtr cbUserData)
{
    d_cbFunc = cbFunc;
    d_cbUserData = cbUserData;
    d_cbList = 0;
    d_type = 0;
}

/********************************************************************
 * ~Callback()
 ********************************************************************/
Callback::~Callback()
{
    if (d_cbList) {
        d_cbList->RemoveCb(this);
    }
}

/********************************************************************
 * setList()
 ********************************************************************/
void Callback::setList(CallbackList *cbList)
{
    d_cbList = cbList;
}

/********************************************************************
 * set_type()
 ********************************************************************/
void Callback::set_type(CallbackType *type)
{
    d_type = type;
}

/********************************************************************
 * Invoke()
 ********************************************************************/
int Callback::Invoke(Uint32 argc, Tcl_Obj *const objv[])
{
    return d_cbFunc(d_cbUserData, d_type->get_interp(), argc, objv);
}


