/****************************************************************************
 *                      RemoteAppClientConnection.h
 *
 * Author: Matthew Ballance
 * Desc:
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_REMOTE_APP_CLIENT_CONNECTION_H
#define INCLUDED_REMOTE_APP_CLIENT_CONNECTION_H
#include "RemoteAppConnection.h"
#include <tcl.h>

class IntChClientListener;
class RemoteAppClientConnection : public RemoteAppConnection {

    friend class IntChClientListener;

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * RemoteAppClientConnection()
         ************************************************************/
        RemoteAppClientConnection(Tcl_Interp *interp, Int32 port);

        /************************************************************
         * ~RemoteAppClientConnection()
         ************************************************************/
        virtual ~RemoteAppClientConnection();

        /************************************************************
         * HandleDisconnect()
         ************************************************************/
        virtual void HandleDisconnect();

        /************************************************************
         * Connect()
         ************************************************************/
        virtual int Connect();

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

        /************************************************************
         * ConnectProc()
         ************************************************************/
        static void ConnectProc(ClientData clientData);
        
        /************************************************************
         * TryConnect()
         ************************************************************/
        Int32 TryConnect();

        /************************************************************
         * SetupRetry()
         ************************************************************/
        void SetupRetry();

        /************************************************************
         * HandleConnect()
         ************************************************************/
        void HandleConnect();

        /************************************************************
         * HandleConnectComplete()
         ************************************************************/
        void HandleConnectComplete();

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:

        Int32            d_port;
        Int32            d_backoffIdx;
        Tcl_TimerToken   d_timerToken;
        Int32            d_connectAck;

        static Int32     d_backoffPattern[];
        static Int32     d_backoffLen;
};

#endif /* INCLUDED_REMOTE_APP_CLIENT_CONNECTION_H */
