/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <libgnomevfs/gnome-vfs.h>

#ifndef _Included_org_gnu_gnomevfs_VFSFileInfo
#define _Included_org_gnu_gnomevfs_VFSFileInfo
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_gnu_gnomevfs_VFSFileInfo
 * Method:    gnome_vfs_file_info_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSFileInfo_gnome_1vfs_1file_1info_1new
  (JNIEnv *env, jclass cls)
{
	return (jint)gnome_vfs_file_info_new();
}

/*
 * Class:     org_gnu_gnomevfs_VFSFileInfo
 * Method:    getName
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gnomevfs_VFSFileInfo_getName
  (JNIEnv *env, jclass cls, jint handle)
{
	return (*env)->NewStringUTF(env, ((GnomeVFSFileInfo*)handle)->name);
}

/*
 * Class:     org_gnu_gnomevfs_VFSFileInfo
 * Method:    getValidFields
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSFileInfo_getValidFields
  (JNIEnv *env, jclass cls, jint handle)
{
	return (jint)((GnomeVFSFileInfo*)handle)->valid_fields;
}

/*
 * Class:     org_gnu_gnomevfs_VFSFileInfo
 * Method:    getFileType
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSFileInfo_getFileType
  (JNIEnv *env, jclass cls, jint handle)
{
	return (jint)((GnomeVFSFileInfo*)handle)->type;
}

/*
 * Class:     org_gnu_gnomevfs_VFSFileInfo
 * Method:    getFilePermissions
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSFileInfo_getFilePermissions
  (JNIEnv *env, jclass cls, jint handle)
{
	return (jint)((GnomeVFSFileInfo*)handle)->permissions;
}

/*
 * Class:     org_gnu_gnomevfs_VFSFileInfo
 * Method:    getFileFlags
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSFileInfo_getFileFlags
  (JNIEnv *env, jclass cls, jint handle)
{
	return (jint)((GnomeVFSFileInfo*)handle)->flags;
}

/*
 * Class:     org_gnu_gnomevfs_VFSFileInfo
 * Method:    getFileSize
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSFileInfo_getFileSize
  (JNIEnv *env, jclass cls, jint handle)
{
	return (jint)((GnomeVFSFileInfo*)handle)->size;
}

/*
 * Class:     org_gnu_gnomevfs_VFSFileInfo
 * Method:    getBlockCount
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSFileInfo_getBlockCount
  (JNIEnv *env, jclass cls, jint handle)
{
	return (jint)((GnomeVFSFileInfo*)handle)->block_count;
}

/*
 * Class:     org_gnu_gnomevfs_VFSFileInfo
 * Method:    getMimeType
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gnomevfs_VFSFileInfo_getMimeType
  (JNIEnv *env, jclass cls, jint handle)
{
	return (*env)->NewStringUTF(env, ((GnomeVFSFileInfo*)handle)->mime_type);
}

/*
 * Class:     org_gnu_gnomevfs_VFSFileInfo
 * Method:    getSymlinkName
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gnomevfs_VFSFileInfo_getSymlinkName
  (JNIEnv *env, jclass cls, jint handle)
{
	return (*env)->NewStringUTF(env, ((GnomeVFSFileInfo*)handle)->symlink_name);
}

/*
 * Class:     org_gnu_gnomevfs_VFSFileInfo
 * Method:    getAtime
 * Signature: (I)J
 */
JNIEXPORT jlong JNICALL Java_org_gnu_gnomevfs_VFSFileInfo_getAtime
  (JNIEnv *env, jclass cls, jint handle)
{
	return (jlong)((GnomeVFSFileInfo*)handle)->atime;
}

/*
 * Class:     org_gnu_gnomevfs_VFSFileInfo
 * Method:    getCtime
 * Signature: (I)J
 */
JNIEXPORT jlong JNICALL Java_org_gnu_gnomevfs_VFSFileInfo_getCtime
  (JNIEnv *env, jclass cls, jint handle)
{
	return (jlong)((GnomeVFSFileInfo*)handle)->ctime;
}

/*
 * Class:     org_gnu_gnomevfs_VFSFileInfo
 * Method:    getMtime
 * Signature: (I)J
 */
JNIEXPORT jlong JNICALL Java_org_gnu_gnomevfs_VFSFileInfo_getMtime
  (JNIEnv *env, jclass cls, jint handle)
{
	return (jlong)((GnomeVFSFileInfo*)handle)->mtime;
}

#ifdef __cplusplus
}
#endif
#endif
