\function{get_process_input}
\synopsis{get_process_input}
\usage{Void get_process_input (Int_Type tsecs);}
\description
  Read all pending input by all subprocesses.  If no input is
  available, this function will wait for input until \var{tsecs} tenth of
  seconds have expired.
\done

\function{kill_process}
\synopsis{kill_process}
\usage{Void kill_process (Int_Type id);}
\description
  Kill the subprocess specified by the process handle \var{id}.
\done

\function{open_process}
\synopsis{open_process}
\usage{Int_Type open_process (name, argv1, argv2, ..., argvN, N);}
\description
  Returns id of process, -1 upon failure.
\done

\function{process_mark}
\synopsis{process_mark}
\usage{User_Mark process_mark (Int_Type id);}
\description
  This function returns the user mark that contains the position of the
  last output by the process.
\done

\function{process_query_at_exit}
\synopsis{Whether or not to silently kill a process at exit}
\usage{Void process_query_at_exit (Int_Type pid, Int_Type query)}
\description
  The \var{process_query_at_exit} may be used to specify whether or
  not the process specified by \var{pid} should be silently ignored
  when the editor exits.  If the parameter \var{query} is non-zero,
  the user will be reminded the process exists before exiting.
\seealso{open_process, kill_process, exit_jed}
\done

\function{run_shell_cmd}
\synopsis{run_shell_cmd}
\usage{Void run_shell_cmd (String cmd);}
\description
  The \var{run_shell_cmd} function may be used to run \var{cmd} in a separate
  process.  Any output generated by the process is inserted into the
  buffer at the current point.  It generates a S-Lang error if the
  process specified by \var{cmd} could not be opened.  Otherwise, it
  returns the exit status of the process.
\done

\function{send_process}
\synopsis{send_process}
\usage{Void send_process (Int_Type id, String s);}
\description
  Undocumented
\done

\function{send_process_eof}
\synopsis{send_process_eof}
\usage{send_process_eof (Int_Type pid);}
\description
  This function closes the \var{stdin} of the process specified by the
  handle \var{pid}.
\done

\function{set_process}
\synopsis{set_process}
\usage{Void set_process (Int_Type pid, String what, String value);}
\description
  \var{pid} is the process handle returned by \var{open_process}.  The second
  parameter, \var{what}, specifies what to set.  It must be one of the
  strings:
#v+
        "signal" :  indicates that 'value' is the name of a function to call
                    when the process status changed.  The function specified
                    by 'value' must be declared to accept an argument list:
                    (pid, flags, status) where 'pid' has the same
                    meaning as above and flags is an integer with the
                    meanings: 
                      1: Process Running
                      2: Process Stopped
                      4: Process Exited Normally
                      8: Process Exited via Signal
                    The meaning of the \var{status} parameter depends
                    upon the \var{flags} parameter.  If the process
                    exited normally, then \var{status} indicates its
                    return status.  Otherwise \var{status} represents
                    the signal that either stopped or killed the
                    process.
                    Note: when this function is called, the current buffer is
                    guaranteed to be the buffer associated with the process.
       
       "output" :   This parameter determines how output from the process is
                    is processed.  If the 'value' is the empty string "", output
                    will go to the end of the buffer associated with the process
                    and the point will be left there.
                    If value is ".", output will go at the current buffer position.
                    If value is "@", output will go to the end of the buffer but
                    the point will not move.  Otherwise, 'value' is the name of
                    a slang function with arguments: (pid, data) where pid has
                    the above meaning and data is the output from the process.
#v-
\done

\function{signal_process}
\synopsis{signal_process}
\usage{Void signal_process (Int_Type pid, Int_Type signum);}
\description
  This function may be used to send a signal to the process whose
  process handle is given by \var{pid}.  The \var{pid} must be a valid handle
  that was returned by \var{open_process}.
\seealso{open_process, kill_process, send_process_eof}
\done

