/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagTypeCDATASection;
import au.id.jericho.lib.html.StartTagTypeComment;
import au.id.jericho.lib.html.StartTagTypeDoctypeDeclaration;
import au.id.jericho.lib.html.StartTagTypeMarkupDeclaration;
import au.id.jericho.lib.html.StartTagTypeNormal;
import au.id.jericho.lib.html.StartTagTypeServerCommon;
import au.id.jericho.lib.html.StartTagTypeServerCommonEscaped;
import au.id.jericho.lib.html.StartTagTypeUnregistered;
import au.id.jericho.lib.html.StartTagTypeXMLDeclaration;
import au.id.jericho.lib.html.StartTagTypeXMLProcessingInstruction;
import au.id.jericho.lib.html.TagType;

public abstract class StartTagType
extends TagType {
    private final EndTagType correspondingEndTagType;
    private final boolean hasAttributes;
    private final boolean isNameAfterPrefixRequired;
    static final String START_DELIMITER_PREFIX = "<";
    public static final StartTagType UNREGISTERED = StartTagTypeUnregistered.INSTANCE;
    public static final StartTagType NORMAL = StartTagTypeNormal.INSTANCE;
    public static final StartTagType COMMENT = StartTagTypeComment.INSTANCE;
    public static final StartTagType XML_DECLARATION = StartTagTypeXMLDeclaration.INSTANCE;
    public static final StartTagType XML_PROCESSING_INSTRUCTION = StartTagTypeXMLProcessingInstruction.INSTANCE;
    public static final StartTagType DOCTYPE_DECLARATION = StartTagTypeDoctypeDeclaration.INSTANCE;
    public static final StartTagType MARKUP_DECLARATION = StartTagTypeMarkupDeclaration.INSTANCE;
    public static final StartTagType CDATA_SECTION = StartTagTypeCDATASection.INSTANCE;
    public static final StartTagType SERVER_COMMON = StartTagTypeServerCommon.INSTANCE;
    public static final StartTagType SERVER_COMMON_ESCAPED = StartTagTypeServerCommonEscaped.INSTANCE;

    protected StartTagType(String string, String string2, String string3, EndTagType endTagType, boolean bl, boolean bl2, boolean bl3) {
        super(string, string2.toLowerCase(), string3, bl, START_DELIMITER_PREFIX);
        if (!this.getStartDelimiter().startsWith(START_DELIMITER_PREFIX)) {
            throw new IllegalArgumentException("startDelimiter of a start tag must start with \"<\"");
        }
        this.correspondingEndTagType = endTagType;
        this.hasAttributes = bl2;
        this.isNameAfterPrefixRequired = bl3;
    }

    public final EndTagType getCorrespondingEndTagType() {
        return this.correspondingEndTagType;
    }

    public final boolean hasAttributes() {
        return this.hasAttributes;
    }

    public final boolean isNameAfterPrefixRequired() {
        return this.isNameAfterPrefixRequired;
    }

    public boolean atEndOfAttributes(Source source, int n, boolean bl) {
        return source.getParseText().containsAt(this.getClosingDelimiter(), n);
    }

    protected final StartTag constructStartTag(Source source, int n, int n2, String string, Attributes attributes) {
        return new StartTag(source, n, n2, this, string, attributes);
    }

    protected final Attributes parseAttributes(Source source, int n, String string) {
        return Attributes.construct(source, n, this, string);
    }
}

