/*
    Copyright (C) 2008 Fons Adriaensen <fons@kokkinizita.net>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <math.h>
#include "meterwin.h"


Meterwin::Meterwin (X_window *parent, int xpos, int ypos, int type, XftColor *bgnd, Pixmap pixm) :
    X_window (parent, xpos, ypos, 100, 100, bgnd->pixel),
    _type (type),
    _bgnd (bgnd),
    _xs (100),
    _ys (100),
    _col1 (0),
    _col2 (0),
    _val1 (0),
    _val2 (0)
{
    switch (type)
    {
    case MVUM:
    case SVUM:
    case MPPM:
    case SPPM:
        XSetWindowBackgroundPixmap (dpy (), win (), pixm);
	_xs = 216;
	_ys = 216;
	_xc = 107;
	_yc = 167;
	_r1 = 19;
	_r2 = 108;
	break;

    case MPPM2:
    case SPPM2:
        XSetWindowBackgroundPixmap (dpy (), win (), pixm);
	_xs = 176;
	_ys = 176;
	_xc = 87;
	_yc = 136;
	_r1 = 16;
	_r2 = 80;
	break;
    }	
    x_resize (_xs, _ys);
    x_add_events (ExposureMask);
    x_map ();
}

 
Meterwin::~Meterwin (void)
{
}

 
void Meterwin::handle_event (XEvent *E)
{
    switch (E->type)
    {
    case Expose:
	expose ((XExposeEvent *) E);
	break;
    }  
}


void Meterwin::expose (XExposeEvent *E)
{
    if (E->count) return;
    redraw ();
}


void Meterwin::set_val (float v1, float v2)
{
    switch (_type)
    {
    case MVUM:
    case SVUM:
	_val1 = vum_map (v1);
	_val2 = vum_map (v2);
	break;

    case MPPM:
    case SPPM:
    case MPPM2:
    case SPPM2:
	_val1 = ppm_map (v1);
	_val2 = ppm_map (v2);
	break;
    }
}


void Meterwin::update (void)
{
    redraw ();
}


void Meterwin::redraw (void)
{
    if (_type < NTYPES)
    {
	XClearWindow (dpy (), win ());
	needle (_val1, _col1);
	if (_type & 1) needle (_val2, _col2);
    }
}


void Meterwin::needle (float val, XftColor *col)
{
    X_draw D (dpy (), win (), dgc (), 0);
    float  c, s;

    if (val < 0.00f) val = 0.00f;
    if (val > 1.05f) val = 1.05f;
    D.setcolor (col);
    val = (val - 0.5f) * 1.5708f;
    c = cosf (val);
    s = sinf (val);
    D.move (_xc + (int)(s * _r1), (int)(_yc - c * _r1));
    D.draw (_xc + (int)(s * _r2), (int)(_yc - c * _r2));
}
