#!/usr/bin/python

import jppy
import vobject
import datetime

env = jppy.environment.Environment()
calendar   = env.calendar
tasks      = env.taskList
calendar_categories = calendar.getCategories()
task_categories     = tasks.getCategories()

cal = vobject.iCalendar()

cal.add('method').value = "PUBLISH"
cal.add('calscale').value = "GREGORIAN"
cal.add('x-wr-calname').value = "Palm Calendar"

# to work well with Rainlender2, we need timezone information :-/

# to work well with calend by Gene Cash on the N8x0, we need to set
# description == summary

for task in tasks.records():
    #print task
    #print task.keys()
    vtodo = cal.add('vtodo')
    vtodo.add('summary').value = task["description"]
#    vtodo.add('priority').value    = task["priority"]
    if task["due"]:
        # jppy tasks still use mx.DateTime, not datetime
        vtodo.add('due').value     = datetime.datetime.utcfromtimestamp(task["due"].gmticks())
    if task["complete"]:
        vtodo.add('status').value = "COMPLETED"
    else:
        vtodo.add('status').value = "NEEDS-ACTION"
    vtodo.add('uid').value         = "palm-%s" % task.unique_id
    vtodo.add('dtstamp').value     = datetime.datetime.now()
    vtodo.add('categories').value = [task_categories[task.category]]    

for event in calendar.records():
    vevent = event.ical()
    vevent.add('categories').value = [calendar_categories[event.category]]

print cal.serialize()
