/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar.ext_util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;

public class ClassHeaderReader {
    private int access;
    private String thisClass;
    private String superClass;
    private String[] interfaces;
    private InputStream in;
    private byte[] b = new byte[8192];
    private int[] items = new int[1000];
    private int bsize = 0;
    private MyByteArrayInputStream bin = new MyByteArrayInputStream();
    private DataInputStream data = new DataInputStream(this.bin);
    private static final int CHUNK = 2048;

    public int getAccess() {
        return this.access;
    }

    public String getClassName() {
        return this.thisClass;
    }

    public String getSuperName() {
        return this.superClass;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream in) throws IOException {
        try {
            this.in = in;
            this.bsize = 0;
            this.access = 0;
            this.superClass = null;
            this.thisClass = null;
            this.interfaces = null;
            this.buffer(10);
            if (this.b[0] != -54 || this.b[1] != -2 || this.b[2] != -70 || this.b[3] != -66) {
                throw new IOException("Bad magic number");
            }
            int minorVersion = this.readUnsignedShort(4);
            int majorVersion = this.readUnsignedShort(6);
            int constant_pool_count = this.readUnsignedShort(8);
            this.items = (int[])ClassHeaderReader.resizeArray(this.items, constant_pool_count);
            int index = 10;
            for (int i = 1; i < constant_pool_count; ++i) {
                int size;
                this.buffer(index + 3);
                byte tag = this.b[index];
                this.items[i] = index + 1;
                switch (tag) {
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        size = 4;
                        break;
                    }
                    case 5: 
                    case 6: {
                        size = 8;
                        ++i;
                        break;
                    }
                    case 1: {
                        size = 2 + this.readUnsignedShort(index + 1);
                        break;
                    }
                    case 7: 
                    case 8: {
                        size = 2;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown constant pool tag " + tag);
                    }
                }
                index += size + 1;
            }
            this.buffer(index + 8);
            this.access = this.readUnsignedShort(index);
            this.thisClass = this.readClass(index + 2);
            this.superClass = this.readClass(index + 4);
            int interfaces_count = this.readUnsignedShort(index + 6);
            this.buffer((index += 8) + interfaces_count * 2);
            this.interfaces = new String[interfaces_count];
            for (int i = 0; i < interfaces_count; ++i) {
                this.interfaces[i] = this.readClass(index);
                index += 2;
            }
        }
        finally {
            in.close();
        }
    }

    private String readClass(int index) throws IOException {
        if ((index = this.readUnsignedShort(index)) == 0) {
            return null;
        }
        index = this.readUnsignedShort(this.items[index]);
        this.bin.readFrom(this.b, this.items[index]);
        return this.data.readUTF();
    }

    private int readUnsignedShort(int index) {
        byte[] b = this.b;
        return (b[index] & 0xFF) << 8 | b[index + 1] & 0xFF;
    }

    private void buffer(int amount) throws IOException {
        if (amount > this.b.length) {
            this.b = (byte[])ClassHeaderReader.resizeArray(this.b, this.b.length * 2);
        }
        if (amount > this.bsize) {
            int rounded = (int)(2048.0 * Math.ceil((float)amount / 2048.0f));
            this.bsize += ClassHeaderReader.read(this.in, this.b, this.bsize, rounded - this.bsize);
            if (amount > this.bsize) {
                throw new EOFException();
            }
        }
    }

    private static int read(InputStream in, byte[] b, int off, int len) throws IOException {
        int total;
        int result;
        for (total = 0; total < len && (result = in.read(b, off + total, len - total)) != -1; total += result) {
        }
        return total;
    }

    private static Object resizeArray(Object array, int length) {
        if (Array.getLength(array) < length) {
            Object newArray = Array.newInstance(array.getClass().getComponentType(), length);
            System.arraycopy(array, 0, newArray, 0, Array.getLength(array));
            return newArray;
        }
        return array;
    }

    private static class MyByteArrayInputStream
    extends ByteArrayInputStream {
        public MyByteArrayInputStream() {
            super(new byte[0]);
        }

        public void readFrom(byte[] buf, int pos) {
            this.buf = buf;
            this.pos = pos;
            this.count = buf.length;
        }
    }
}

