/* jslaunch 2.0: a joystick button triggered shell command execution daemon
   Copyright (C) Sander Pronk, 1998
   
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define TRUE 1
#define FALSE 0

#define MICRO_IN_MILLI 1000
/* how many microsecs there are in a millisec */

#define DEFAULTPOLL 500*MICRO_IN_MILLI
/* the default polling time, 0.5 seconds */

#define BOUNCETIME 300*MICRO_IN_MILLI
/* default wait time before actually reading the joystick for 
   getting the buttons (0.3 seconds) */

#define PORT 0x201
/* The joystick IO port */
#define PORTLEN 1
/* number of ports from PORT */
#define PERMLEVEL 1
/* permission level to read from PORT */

#define MASKBUT1 0x10
#define MASKBUT2 0x20
#define MASKBUT3 0x40
#define MASKBUT4 0x80
#define MASKALL 0xf0
#define AXES 0x0f
/* The buttons */

#define NMASK 16
/* nr. of possible combinations, including 0 */
#define MASKMASK 0x0f
/* we only have 4 buttons/bits */
#define SHIFTVAL 4
/* value to shift port reads by */

#define POLLTIME_MAX 60000
/* maximum allowed poll time, 60 seconds */

#define EXPN "\nUsage: jslaunch [-t secs] [-r [1234] \"cmd\"]\n\
Runs command when two joystick buttons are pressed,\n\
See man page jslaunch(1) for details\n"
#define EXPNLEN 134

#define TIMEERR "Time out of range\n"
#define TIMEERRLEN 18

#define WRONGBUT "Wrong button number specified, must be in range 1..4\n"
#define WRONGBUTLEN 53

#define BUTTWICE "Button already specified within button list\n"
#define BUTTWICELEN 44

#define ACTTWICE "There already is an action for this button combination\n"
#define ACTTWICELEN 55

#define FEWOPTS "Not enough parameters for option\n"
#define FEWOPTSLEN 33

#define NOPERM "Could not get permission to read from joystick port\n"
#define NOPERMLEN 52

#define ACTPRESSED "Joystick buttons that trigger action already pressed\n"
#define ACTPRESSEDLEN 53

#define NOFORK "Fork not succesful\n"
#define NOFORKLEN 19

#define NOCOMMAND "No command to execute\n"
#define NOCOMMANDLEN 22

#define UIDFAIL "Failure in giving up setuid privileges\n"
#define UIDFAILLEN 39

#define OPENFAIL "Couldn't open lockfile\n"
#define OPENFAILLEN 23

#define LOCKFAIL "Lockfile already locked\n"
#define LOCKFAILLEN 24

int readargs(int argc, char *argv[], char *msk[], int *polltime,
	     int *bounce, int *joymask, int *dmn, 
	     char **lockfile);
/* read the arguments from argc, argv and construct 
   msk (the array of commands), sleep, bounce,
   readmask, dmn (whether to be a daemon), lockfile and returning
   0 if no error occurred, 1 otherwise */

int readmask(const char *str);
/* read a mask from string str and return it, returning 0 if an error
   occurred */

int readtime(const char *st);
/* read a time in SLEEPFREQ from string st into tm, returning
   -1 if no error occurred, the time otherwise */


void setlock(char *lockfile);
/* set a lock on lockfile */
