
/*
 * id3.h -- written for Juice
 *  Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef MPG123_ID3_H
#define MPG123_ID3_H

#include "typedefs.h"							 /* bool */

/* ID3 tag structure */
typedef struct
{
   char title[31];
   char artist[31];
   char album[31];
   char year[5];
   bool has_tracknum;
   int tracknum;
   char comment[31];
   /* With ID3 v1.0, the comment is 30 chars long */
   /* With ID3 v1.1, if comment[28] == 0 then comment[29] == tracknum */
   char genre[33];
} id3_t;

/*
 * Extract tag information from a MP3 file If getid3() returns TRUE,
 * the tag info was available and was extracted succesfully, FALSE
 * if not successful.
 */
bool getid3 (id3_t *tag,const char *filename);

#endif
