# $Id: Morpheme.pm,v 1.9 2003/06/22 16:10:40 tsuchiya Exp $
package Juman::Morpheme;
require 5.000;
use Exporter;
use Juman::Katuyou;
use strict;
use vars qw/ @ISA @EXPORT_OK @ATTRS /;
@ISA = qw/ Juman::Katuyou Exporter /;
@EXPORT_OK = qw/ @ATTRS /;

=head1 NAME

Juman::Morpheme - ǥ֥ in Juman

=head1 SYNOPSIS

  $m = new Juman::Morpheme( "   ̾ 6 ̾ 2 * 0 * 0" );

=head1 DESCRIPTION

ǤγƼݻ륪֥ȡ

=head1 CONSTRUCTOR

=over 4

=item new ( SPEC, ID )

1 I<SPEC>  Juman νϤƸƤӽФȡιԤƤ
Ϥǥ֥Ȥ롥

=back

=cut
@ATTRS = ( 'midasi',
	   'yomi',
	   'genkei',
	   'hinsi',
	   'hinsi_id',
	   'bunrui',
	   'bunrui_id',
	   'katuyou1',
	   'katuyou1_id',
	   'katuyou2',
	   'katuyou2_id',
	   'imis' );

sub new {
    my( $class, $spec, $id ) = @_;
    my $this = $id ? { id => $id } : {};

    my @value;
    my( @keys ) = @ATTRS;
    $spec =~ s/\s*$//;
    if( $spec =~ s/^\\  \\  \\  ü 1  6// ){
	@value = ( '\ ', '\ ', '\ ', 'ü', '1', '', '6' );
	push( @value, split( / /, $spec, scalar(@keys) - 7 ) );
    } else {
	@value = split( / /, $spec, scalar(@keys) );
    }
    while( @keys and @value ){
	my $key = shift @keys;
	$this->{$key} = shift @value;
    }

    bless $this, $class;
}

=head1 METHODS

=over 4

=item midasi

ǤθФ֤

=cut
sub midasi {
    my( $this ) = @_;
    $this->{midasi} || undef;
}

=item yomi

Ǥɤߤ֤

=cut
sub yomi {
    my( $this ) = @_;
    $this->{yomi} || undef;
}

=item genkei

Ǥδܷ֤

=cut
sub genkei {
    my( $this ) = @_;
    $this->{genkei} || undef;
}

=item hinsi

Ǥʻ֤

=cut
sub hinsi {
    my( $this ) = @_;
    $this->{hinsi} || undef;
}

=item hinsi_id

Ǥʻֹ֤

=cut
sub hinsi_id {
    my( $this ) = @_;
    $this->{hinsi_id} || undef;
}

=item bunrui

Ǥκʬ֤

=cut
sub bunrui {
    my( $this ) = @_;
    $this->{bunrui} || undef;
}

=item bunrui_id

Ǥκʬֹ֤

=cut
sub bunrui_id {
    my( $this ) = @_;
    $this->{bunrui_id} || 0;
}

=item katuyou1

Ǥγѷ֤

=cut
sub katuyou1 {
    my( $this ) = @_;
    $this->{katuyou1} || undef;
}

=item katuyou1_id

Ǥγѷֹ֤

=cut
sub katuyou1_id {
    my( $this ) = @_;
    $this->{katuyou1_id} || 0;
}

=item katuyou2

Ǥγѷ֤

=cut
sub katuyou2 {
    my( $this ) = @_;
    $this->{katuyou2} || undef;
}

=item katuyou2_id

Ǥγѷֹ֤

=cut
sub katuyou2_id {
    my( $this ) = @_;
    $this->{katuyou2_id} || 0;
}

=item imis

Ǥΰ̣֤̣ϡJuman  C<-e2> ץꤷ
Ƽ¹Ԥ롥

=cut
sub imis {
    my( $this ) = @_;
    $this->{imis} || undef;
}

=item push_doukei( DOUKEI )

Ʊ۵ I<DOUKEI> Ͽ롥

=cut
sub push_doukei {
    my( $this, $doukei ) = @_;
    $this->{doukei} ||= [];
    push( @{$this->{doukei}}, $doukei );
}

=item doukei

ǤƱ۵ΥꥹȤ֤

=cut
sub doukei {
    my( $this ) = @_;
    if( defined $this->{doukei} ){
	@{$this->{doukei}};
    } else {
	wantarray ? () : 0;
    }
}

=item id

󥹥ȥ饯ƤӽФȤ˻ꤷ ID ֤

=cut
sub id {
    my( $this ) = @_;
    $this->{id} || undef;
}

=item spec

ǥ֥ȤʸѴ롥

=cut
sub spec {
    my( $this ) = @_;
    sprintf( "%s\n", join( ' ', map( $this->{$_}, grep( defined $this->{$_}, @ATTRS ) ) ) );
}

1;

=back

=head1 SEE ALSO

L<Juman::Katuyou>.

=head1 AUTHORS

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
