/*
   Copyright (C) 2003 Commonwealth Scientific and Industrial Research
   Organisation (CSIRO) Australia

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

   - Neither the name of CSIRO Australia nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
   PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE ORGANISATION OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "config.h"

#include <string.h>

#include <annodex/annodex.h>

#include "anx_tests.h"

#define CMML0 "<clip/>"
#define CMML1 "<clip id=\"test\"/>"
#define CMML2 "<clip id=\"test2\"><desc>Test Description</desc></clip>"
#define CMML3 "<clip><a href=\"http://localhost/\"><desc>Test</desc></clip>"


static int
write_clip_test (void)
{
  ANNODEX * anx;

  INFO ("+ Creating new Annodex writer");
  anx = anx_new (ANX_WRITE);

  if (anx == NULL)
    FAIL("anx_new returned NULL");

  INFO ("+ Inserting NULL clip");
  anx_insert_clip (anx, 0, NULL);

  INFO ("+ Inserting " CMML0);
  anx_insert_cmml (anx, 1, CMML0, strlen (CMML0));

  INFO ("+ Inserting " CMML1);
  anx_insert_cmml (anx, 1, CMML1, strlen (CMML1));

  INFO ("+ Inserting " CMML2);
  anx_insert_cmml (anx, 2, CMML2, strlen (CMML2));

  INFO ("+ Inserting " CMML3);
  anx_insert_cmml (anx, 3, CMML3, strlen (CMML3));

  INFO ("+ Deleting Annodex");
  anx_close (anx);
  return 0;
}

int
main (int argc, char * argv[])
{
  INFO ("Testing clip insertion");
  write_clip_test ();

  exit (EXIT_SUCCESS);
}
