/* ======================================================================
 * Copyright (c) 1998-1999 The Johns Hopkins University.
 * All rights reserved.
 * The following code was written by Theo Schlossnagle for use in the
 * Backhand project at The Center for Networking and Distributed Systems
 * at The Johns Hopkins University.
 * Please refer to the LICENSE file before using this software.
 * ======================================================================
*/

#ifndef _BUILTINS_H_
#define _BUILTINS_H_

#include "httpd.h"

#include "mod_backhand.h"

int backhand_off(request_rec *, ServerSlot *, int *, char *);
int removeSelf(request_rec *, ServerSlot *, int *, char *);
int addSelf(request_rec *, ServerSlot *, int *, char *);
int addPrediction(request_rec *, ServerSlot *, int *, char *);
int byAge(request_rec *, ServerSlot *, int *, char *);
int byCost(request_rec *, ServerSlot *, int *, char *);
int byLoad(request_rec *, ServerSlot *, int *, char *);
int byBusyChildren(request_rec *, ServerSlot *, int *, char *);
int byCPU(request_rec *, ServerSlot *, int *, char *);
int byLogWindow(request_rec *, ServerSlot *, int *, char *);
int byRandom(request_rec *, ServerSlot *, int *, char *);
int HTTPRedirectToName(request_rec *, ServerSlot *, int *, char *);
int HTTPRedirectToIP(request_rec *, ServerSlot *, int *, char *);

int bySession(request_rec *, ServerSlot *, int *, char *);

/* Number of builint functions... Increment this when adding new functions */
#define _BuiltinCount 14

#ifdef IN_MODULE
/* one defined in mod_backhand.c */

struct cpd {
  char *aName;
  char *aString;
  DecisionFunc aFunc;
  struct cpd *next;
};

static struct cpd BuiltinFuncsTable[_BuiltinCount] = {
    {"off", NULL, backhand_off, NULL},
    {"byAge", NULL, byAge, NULL},
    {"byCost", NULL, byCost, NULL},
    {"byLoad", NULL, byLoad, NULL},
    {"byBusyChildren", NULL, byLoad, NULL},
    {"byCPU", NULL, byCPU, NULL},
    {"byLogWindow", NULL, byLogWindow, NULL},
    {"byRandom", NULL, byRandom, NULL},
    {"removeSelf", NULL, removeSelf, NULL},
    {"addSelf", NULL, addSelf, NULL},
    {"addPrediction", NULL, addPrediction, NULL},
    {"HTTPRedirectToName", NULL, HTTPRedirectToName, NULL},
    {"HTTPRedirectToIP", NULL, HTTPRedirectToIP, NULL},

    {"bySession", NULL, bySession, NULL}
};
#endif /* IN_MODULE */

#endif
