#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include <sasl.h>

static int err; /* Our last error code */

static int
not_here(char *s)
{
    croak("%s not implemented on this architecture", s);
    return -1;
}

static int _sasl_callback(void *context, int id, const char **result, unsigned *len)
{
  const char *value = (const char *)context;

  if (! result)
    return SASL_BADPARAM;

  switch (id) {
  case SASL_CB_USER:
    *result = value;
    if (len)
      *len = value ? strlen(value) : 0;

    break;
  default:
    return SASL_BADPARAM;
  }
  return SASL_OK;
}

static int _sasl_getpass(sasl_conn_t *conn, 
			 void *context, int id, 
			 sasl_secret_t **secret) {

  if (id != SASL_CB_PASS) return SASL_BADPARAM;

  return SASL_FAIL;
}

static double
constant(char *name, int arg)
{
    errno = 0;
    switch (*name) {
    case 'A':
	break;
    case 'B':
	break;
    case 'C':
	break;
    case 'D':
	break;
    case 'E':
	break;
    case 'F':
	break;
    case 'G':
	break;
    case 'H':
	break;
    case 'I':
	break;
    case 'J':
	break;
    case 'K':
	break;
    case 'L':
	break;
    case 'M':
	break;
    case 'N':
	break;
    case 'O':
	break;
    case 'P':
	break;
    case 'Q':
	break;
    case 'R':
	break;
    case 'S':
	if (strEQ(name, "SASL_BADAUTH"))
#ifdef SASL_BADAUTH
	    return SASL_BADAUTH;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_BADMAC"))
#ifdef SASL_BADMAC
	    return SASL_BADMAC;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_BADPARAM"))
#ifdef SASL_BADPARAM
	    return SASL_BADPARAM;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_BADPROT"))
#ifdef SASL_BADPROT
	    return SASL_BADPROT;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_BADSERV"))
#ifdef SASL_BADSERV
	    return SASL_BADSERV;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_BADVERS"))
#ifdef SASL_BADVERS
	    return SASL_BADVERS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_BUFOVER"))
#ifdef SASL_BUFOVER
	    return SASL_BUFOVER;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_AUTHNAME"))
#ifdef SASL_CB_AUTHNAME
	    return SASL_CB_AUTHNAME;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_ECHOPROMPT"))
#ifdef SASL_CB_ECHOPROMPT
	    return SASL_CB_ECHOPROMPT;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_GETOPT"))
#ifdef SASL_CB_GETOPT
	    return SASL_CB_GETOPT;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_GETPATH"))
#ifdef SASL_CB_GETPATH
	    return SASL_CB_GETPATH;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_GETREALM"))
#ifdef SASL_CB_GETREALM
	    return SASL_CB_GETREALM;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_LANGUAGE"))
#ifdef SASL_CB_LANGUAGE
	    return SASL_CB_LANGUAGE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_LIST_END"))
#ifdef SASL_CB_LIST_END
	    return SASL_CB_LIST_END;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_LOG"))
#ifdef SASL_CB_LOG
	    return SASL_CB_LOG;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_NOECHOPROMPT"))
#ifdef SASL_CB_NOECHOPROMPT
	    return SASL_CB_NOECHOPROMPT;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_PASS"))
#ifdef SASL_CB_PASS
	    return SASL_CB_PASS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_PROXY_POLICY"))
#ifdef SASL_CB_PROXY_POLICY
	    return SASL_CB_PROXY_POLICY;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_SERVER_GETSECRET"))
#ifdef SASL_CB_SERVER_GETSECRET
	    return SASL_CB_SERVER_GETSECRET;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_SERVER_PUTSECRET"))
#ifdef SASL_CB_SERVER_PUTSECRET
	    return SASL_CB_SERVER_PUTSECRET;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_USER"))
#ifdef SASL_CB_USER
	    return SASL_CB_USER;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CB_VERIFYFILE"))
#ifdef SASL_CB_VERIFYFILE
	    return SASL_CB_VERIFYFILE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_CONTINUE"))
#ifdef SASL_CONTINUE
	    return SASL_CONTINUE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_DISABLED"))
#ifdef SASL_DISABLED
	    return SASL_DISABLED;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_ENCRYPT"))
#ifdef SASL_ENCRYPT
	    return SASL_ENCRYPT;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_EXPIRED"))
#ifdef SASL_EXPIRED
	    return SASL_EXPIRED;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_FAIL"))
#ifdef SASL_FAIL
	    return SASL_FAIL;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_GETOPTCTX"))
#ifdef SASL_GETOPTCTX
	    return SASL_GETOPTCTX;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_H"))
#ifdef SASL_H
	    return SASL_H;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_INTERACT"))
#ifdef SASL_INTERACT
	    return SASL_INTERACT;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_IP_LOCAL"))
#ifdef SASL_IP_LOCAL
	    return SASL_IP_LOCAL;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_IP_REMOTE"))
#ifdef SASL_IP_REMOTE
	    return SASL_IP_REMOTE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_LOG_ERR"))
#ifdef SASL_LOG_ERR
	    return SASL_LOG_ERR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_LOG_INFO"))
#ifdef SASL_LOG_INFO
	    return SASL_LOG_INFO;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_LOG_WARNING"))
#ifdef SASL_LOG_WARNING
	    return SASL_LOG_WARNING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_MAXOUTBUF"))
#ifdef SASL_MAXOUTBUF
	    return SASL_MAXOUTBUF;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_MECHNAMEMAX"))
#ifdef SASL_MECHNAMEMAX
	    return SASL_MECHNAMEMAX;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_NEWSECRET"))
#ifdef SASL_NEWSECRET
	    return SASL_NEWSECRET;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_NOAUTHZ"))
#ifdef SASL_NOAUTHZ
	    return SASL_NOAUTHZ;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_NOCHANGE"))
#ifdef SASL_NOCHANGE
	    return SASL_NOCHANGE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_NOMECH"))
#ifdef SASL_NOMECH
	    return SASL_NOMECH;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_NOMEM"))
#ifdef SASL_NOMEM
	    return SASL_NOMEM;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_NOPATH"))
#ifdef SASL_NOPATH
	    return SASL_NOPATH;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_NOTDONE"))
#ifdef SASL_NOTDONE
	    return SASL_NOTDONE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_NOUSER"))
#ifdef SASL_NOUSER
	    return SASL_NOUSER;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_OK"))
#ifdef SASL_OK
	    return SASL_OK;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_PWLOCK"))
#ifdef SASL_PWLOCK
	    return SASL_PWLOCK;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_REALM"))
#ifdef SASL_REALM
	    return SASL_REALM;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_SECURITY_LAYER"))
#ifdef SASL_SECURITY_LAYER
	    return SASL_SECURITY_LAYER;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_SEC_FORWARD_SECRECY"))
#ifdef SASL_SEC_FORWARD_SECRECY
	    return SASL_SEC_FORWARD_SECRECY;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_SEC_NOACTIVE"))
#ifdef SASL_SEC_NOACTIVE
	    return SASL_SEC_NOACTIVE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_SEC_NOANONYMOUS"))
#ifdef SASL_SEC_NOANONYMOUS
	    return SASL_SEC_NOANONYMOUS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_SEC_NODICTIONARY"))
#ifdef SASL_SEC_NODICTIONARY
	    return SASL_SEC_NODICTIONARY;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_SEC_NOPLAINTEXT"))
#ifdef SASL_SEC_NOPLAINTEXT
	    return SASL_SEC_NOPLAINTEXT;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_SEC_PASS_CREDENTIALS"))
#ifdef SASL_SEC_PASS_CREDENTIALS
	    return SASL_SEC_PASS_CREDENTIALS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_SEC_PROPS"))
#ifdef SASL_SEC_PROPS
	    return SASL_SEC_PROPS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_SET_CREATE"))
#ifdef SASL_SET_CREATE
	    return SASL_SET_CREATE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_SET_DISABLE"))
#ifdef SASL_SET_DISABLE
	    return SASL_SET_DISABLE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_SSF"))
#ifdef SASL_SSF
	    return SASL_SSF;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_SSF_EXTERNAL"))
#ifdef SASL_SSF_EXTERNAL
	    return SASL_SSF_EXTERNAL;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_TOOWEAK"))
#ifdef SASL_TOOWEAK
	    return SASL_TOOWEAK;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_TRANS"))
#ifdef SASL_TRANS
	    return SASL_TRANS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_TRYAGAIN"))
#ifdef SASL_TRYAGAIN
	    return SASL_TRYAGAIN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_USERNAME"))
#ifdef SASL_USERNAME
	    return SASL_USERNAME;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_VERSION_MAJOR"))
#ifdef SASL_VERSION_MAJOR
	    return SASL_VERSION_MAJOR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_VERSION_MINOR"))
#ifdef SASL_VERSION_MINOR
	    return SASL_VERSION_MINOR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_VERSION_STEP"))
#ifdef SASL_VERSION_STEP
	    return SASL_VERSION_STEP;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_VRFY_CONF"))
#ifdef SASL_VRFY_CONF
	    return SASL_VRFY_CONF;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_VRFY_OTHER"))
#ifdef SASL_VRFY_OTHER
	    return SASL_VRFY_OTHER;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_VRFY_PASSWD"))
#ifdef SASL_VRFY_PASSWD
	    return SASL_VRFY_PASSWD;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_VRFY_PLUGIN"))
#ifdef SASL_VRFY_PLUGIN
	    return SASL_VRFY_PLUGIN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SASL_WRONGMECH"))
#ifdef SASL_WRONGMECH
	    return SASL_WRONGMECH;
#else
	    goto not_there;
#endif
	break;
    case 'T':
	break;
    case 'U':
	break;
    case 'V':
	break;
    case 'W':
	break;
    case 'X':
	break;
    case 'Y':
	break;
    case 'Z':
	break;
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

/* D'Oh - Callbacks must be global, or allocated statically in the
 * initialition procedure, as they seem to be incorporated by reference
 * This sucks!
 */
static sasl_callback_t callbacks[4], *callback;

typedef sasl_conn_t	*Authen__SASL__Cyrus__Connection;

MODULE = Authen::SASL::Cyrus		PACKAGE = Authen::SASL::Cyrus	

PROTOTYPES: DISABLE

double
constant(name,arg)
	char *		name
	int		arg

void 
error()
	CODE:
	ST(0) = sv_2mortal(newSVpv((char *)sasl_errstring(err,NULL,NULL), 0));
	SvUPGRADE(ST(0), SVt_PVIV);
	SvIVX(ST(0)) = err;
	SvIOK_on(ST(0));

Authen::SASL::Cyrus::Connection
init_connection(service, server, user)
	char *service
	char *server
	char *user
	
	PREINIT:
	sasl_conn_t *conn = NULL;
	char *out = NULL;
	unsigned outlen;
	const char *mech;

	CODE:
	callback = callbacks;

	/* Remember to increment the size of the array before adding to
	   these */
	callback->id = SASL_CB_USER;
	callback->proc = &_sasl_callback;
	callback->context = strdup(user);
	++callback;
	
	callback->id = SASL_CB_PASS;
	callback->proc = &_sasl_getpass;
	callback->context = NULL;
	++callback;

	callback->id = SASL_CB_LIST_END;
	callback->proc = NULL;
	callback->context = NULL;
	++callback;

	err = sasl_client_init(callbacks);
	if (err != SASL_OK) XSRETURN_UNDEF;

        err = sasl_client_new(service,server,NULL,0,&conn);
        if (err != SASL_OK) XSRETURN_UNDEF;

	RETVAL=conn;

        OUTPUT:
        RETVAL
        

SV *
start(conn, mechanism)
   	Authen::SASL::Cyrus::Connection conn
	char *mechanism

	PREINIT:
	char *out;
	unsigned outlen;
	const char *mech;
  
	CODE:

	err = sasl_client_start(conn, mechanism, NULL, NULL, 
				&out, &outlen, &mech);

	if (err!=SASL_CONTINUE && err!=SASL_OK) XSRETURN_UNDEF;

	if (outlen==0) {
          RETVAL = newSVpv("",0);
        } else {
 	  RETVAL = newSVpv(out,outlen);
        }

        OUTPUT:
        RETVAL

SV *
respond(conn, insv)
	Authen::SASL::Cyrus::Connection conn
	SV *insv

	PREINIT:
	char *out, *in;
	unsigned outlen, inlen;
	sasl_interact_t *client_interact=NULL;

	CODE:
	in=SvPV(insv,inlen);
	err = sasl_client_step(conn, in, inlen, NULL, 
			       &out, &outlen);
	
        if (err!=SASL_CONTINUE && err!=SASL_OK) XSRETURN_UNDEF;

	if (outlen==0) {
          RETVAL = newSVpv("",0);
        } else {
 	  RETVAL = newSVpv(out,outlen);
        }

	OUTPUT:
	RETVAL
