------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                         Copyright (C) 2000-2002                          --
--                               ACT-Europe                                 --
--                                                                          --
--  Authors: Dmitriy Anisimkov - Pascal Obry                                --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
--  As a special exception, if other files instantiate generics from this   --
--  unit, or you link this unit with other files to produce an executable,  --
--  this  unit  does not  by itself cause  the resulting executable to be   --
--  covered by the GNU General Public License. This exception does not      --
--  however invalidate any other reasons why the executable file  might be  --
--  covered by the  GNU Public License.                                     --
------------------------------------------------------------------------------

--  $Id: aws-hotplug-get_status.adb,v 1.6 2002/10/12 17:10:48 obry Exp $

function AWS.Hotplug.Get_Status
  (Filters : in Filter_Set) return Templates_Parser.Translate_Table
is

   use Templates_Parser;

   Regexp : Vector_Tag;
   URL    : Vector_Tag;

   --  Avoid : may be referenced before it has a value
   pragma Warnings (Off, Regexp);
   pragma Warnings (Off, URL);

begin
   for K in 1 .. Filters.Count loop
      Regexp := Regexp & Filters.Set (K).Regexp_Str;
      URL    := URL    & Filters.Set (K).URL;
   end loop;

   return Translate_Table'(Assoc ("HP_REGEXP_V", Regexp),
                           Assoc ("HP_URL_V",    URL));
end AWS.Hotplug.Get_Status;
