------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                         Copyright (C) 2000-2004                          --
--                               ACT-Europe                                 --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
------------------------------------------------------------------------------

with Strings_Maps;

package AWS.Containers.Key_Value is

   package Table is new Strings_Maps (String, "=");

   subtype Set is Table.Containers.Map;
   type Set_Access is access Set;

   subtype Cursor is Table.Containers.Cursor;
   No_Element : Cursor renames Table.Containers.No_Element;

   function Has_Element
     (C : in Cursor)
      return Boolean
      renames Table.Containers.Has_Element;

end AWS.Containers.Key_Value;
