/***************************************************************************
 $RCSfile: ctkvkcard.h,v $
                             -------------------
    cvs         : $Id: ctkvkcard.h,v 1.4 2003/04/24 01:43:29 aquamaniac Exp $
    begin       : Tue Aug 28 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 Changes

 */


#ifndef CTKVKCARD_H
#define CTKVKCARD_H

struct insuranceData;
class CTKVKCard;

// used to convert german "Umlaute"
#define k_KVK_AE 0x5b
#define k_KVK_OE 0x5c
#define k_KVK_UE 0x5d
#define k_KVK_ae 0x7b
#define k_KVK_oe 0x7c
#define k_KVK_ue 0x7d
#define k_KVK_ss 0x7e


#include <string>

#include <chipcard/cterror.h>
#include <chipcard/ctcard.h>
#include <chipcard/ctmemorycard.h>


/**
 * This struct contains all info that can be found on a german health insurance
 * card.
 * @author Martin Preuss <martin@libchipcard.de>
 */
struct insuranceData {
    /** the name of the company (like DAK, AOK etc) */
    string insuranceCompanyName;
    /** the numeric code of the company */
    string insuranceCompanyCode;
    /** the patient's insurance number */
    string insuranceNumber;
    /** the patient's insurance state */
    string insuranceState;
    /** patients title (like Dr.) */
    string title;
    /** guess what */
    string forename;
    /** suffix like "von", "van" etc */
    string nameSuffix;
    /** patient's name */
    string name;
    /** date of birth DDMMYYYY */
    string dateOfBirth;
    /** street and number */
    string addrStreet;
    /** state (Niedersachsen, Hamburg, Bremen etc), not set on most cards */
    string addrState;
    /** postal code of the address */
    string addrPostalCode;
    /** city the patient lives in */
    string addrCity;
    /** card is valid until this date (MMYY) */
    string bestBefore;
    /** "1" if western germany, "9" if one of the new FRG states */
    string eastOrWest;
    /** card number */
    string cardNumber;
    /** true, if the data read off the card is valid (false on checksum error)*/
    bool isValid;
};


/**
 * This class provides basic access to german health insureance cards.
 * @author Martin Preuss <martin@libchipcard.de>
 * @ingroup scards
 * @short Special class for German medical cards
 */
class CHIPCARD_API CTKVKCard : public CTMemoryCard {
private:
  bool _fromString(string s, insuranceData &data);

public:
  /** @name Constructors/Destructor
   *
   * Methods to retrieve the private members of this class.
   */
  //@{
  /**
   * This constructor is mainly used by derived classes to transform
   * a basic CTCard object to a more special one. This allows opening a
   * card as a CTCard object and then create e.g. a CTMemoryCard from
   * this one. The source card will be immidiately closed. The only thing
   * you should do with it is to delete it. You should NOT use it any
   * longer !!
   * @param c reference to the CTCard object to be transformed
   * @author Martin Preuss<martin@libchipcard.de>
   */
  CTKVKCard(const CTCard &c);

  ~CTKVKCard();
  //@}

  /** @name Opening and closing operations
   *
   * Methods to connect and disconnect the card. Most other methods
   * only work if the card is open.
   */
  //@{
  /**
   * When this method is called normally the card is already opened by
   * means of @ref openCard(). However, it is likely that openCard() has
   * been called assuming this card is only a CTCard() object, nothing
   * special. You may then call THIS method here on all known card classes
   * to check for the type of this card.
   * This method must assume that any file on the card is already selected,
   * so it is in most cases a good idea to select the MF as the first action
   * of this method.
   * If the executing class finds that the card inserted is not of a type
   * it can handle then it MUST return an error.
   */
  virtual CTError reopenCard();
  //@}

  /** @name Informational methods
   *
   * These methods tell you about the type and the status of the card.
   */
  //@{
  /**
   * This method returns a short name of the class which handles this card.
   * A HBCI card for example returns "HBCICard". So you can use this method
   * to check for the type of the card.
   */
  virtual string cardType();

  /**
   * This method returns a comma separated list of all card types this card
   * inherits including the type of this card, e.g. a HBCI card would
   * return "CTProcessorCard, HBCICard". If you overload this method in your
   * own class (you SHOULD) you simply have to call this method of the
   * class it directly inherits. That class will then do the same, so that
   * there is a list upon return.
   */
  virtual string cardTypes();
  //@}

  /** @name Commands
   *
   * These methods allow you to send a command to the card. Of course the
   * card needs to be already open.
   */
  //@{
  /**
   * Reads the cards data into the insuranceData struct.
   * The content of this struct is only valid, if it's "isValid" flag
   * is set. Otherwise the card may be corrupted.
   * @author Martin Preuss <martin@libchipcard.de>
   * @param data reference to the struct to fill
   * @return CTError object that holds the result (call isOk() to see if
   * there was an error)
   */
  CTError readCardData(insuranceData &data);
  //@}

};


#endif






