/* 
 * $Id: ctkeditable.h,v 1.8 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#ifndef __CTKEDITABLE_H__
# define __CTKEDITABLE_H__

#include "ctktype.h"

typedef struct CtkEditable_S {
	CtkWidget widget;

	guint curpos;
	gchar *text_start;
	gchar *text;
	gboolean visible;
	guint16 max_length;

	gboolean editable;
} CtkEditable;

#define CTK_EDITABLE(obj)	CTK_CHECK_CAST((obj), CtkEditable, CtkTypeEditable)

void ctk_editable_init(CtkEditable *editable);
void ctk_editable_set_editable(CtkEditable *editable, gboolean is_editable);
gchar * ctk_editable_get_chars(CtkEditable *editable, gint start_pos, gint end_pos);
gpointer ctk_editable_destroy(CtkEditable *editable);
void ctk_editable_real_size(CtkWidget* widget);

#endif
