/* 
 * $Id: ctklistitem.c,v 1.4 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"

/* Initialize the List item Structure */
void ctk_list_item_init(CtkListItem *listitem)
{
	ctk_item_init(&listitem->item);       	
	
	ctk_signal_new("activate",CtkTypeListItem);

	((CtkObject *)listitem)->type = CtkTypeListItem;
	((CtkWidget *)listitem)->width = 1;
	((CtkWidget *)listitem)->height = 1;
	((CtkWidget *)listitem)->orig_width = 1;
	((CtkWidget *)listitem)->orig_height = 1;
//	((CtkWidget *)listitem)->key_event_handler = ctk_button_key_handle_events;
//	((CtkWidget *)listitem)->mouse_event_handler = ctk_button_mouse_handle_events;

	CTK_OBJECT(listitem)->type = CtkTypeListItem;
}

CtkWidget* ctk_list_item_new(void)
{
	CtkListItem* listitem;

	listitem = g_malloc(sizeof(CtkListItem));

	ctk_list_item_init(listitem);
	return ((CtkWidget *)listitem);
}

CtkWidget* ctk_list_item_new_with_label(const gchar* label)
{
	CtkWidget* listitem;
	CtkWidget* label_widget;

	listitem = ctk_list_item_new();

	if (label)
	{
		label_widget = ctk_label_new(label);
		ctk_misc_set_alignment(CTK_MISC(label_widget), 0, 0);
		ctk_widget_show(label_widget);
		ctk_container_add(CTK_CONTAINER(listitem),label_widget);
	}

	return (listitem);
}
