/* 
 * $Id: ctkmenu.c,v 1.17 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"
#include "ctkcolor.h"

/* Initialize the Menu Structure */
void ctk_menu_init(CtkMenu* menu)
{
	ctk_menu_shell_init(&menu->menushell);
	CTK_OBJECT(menu)->type = CtkTypeMenu;
	
	menu->selected_item = 0;
	menu->num_items = 0;
	
	((CtkWidget *)menu)->width = 1;
	((CtkWidget *)menu)->height = 1;
	((CtkWidget *)menu)->orig_width = 1;
	((CtkWidget *)menu)->orig_height = 1;
}

CtkWidget* ctk_menu_new(void)
{
	CtkMenu *menu;

	menu = g_malloc(sizeof(CtkMenu));

	ctk_menu_init(menu);

	return ((CtkWidget *)menu);
}

/* Append an item into the specified menu */
void ctk_menu_append(CtkMenu* menu, CtkWidget* child)
{
      CtkWidget* widgets[2];
      widgets[0] = child;
      widgets[1] = NULL;

      menu->num_items++;

      ctk_clist_append_widget(CTK_CLIST(menu), widgets);
}

/* Prepend an item into the specified menu */
void ctk_menu_prepend(CtkMenu* menu, CtkWidget* child)
{
      CtkWidget* widgets[2];
      widgets[0] = child;
      widgets[1] = NULL;

      menu->num_items++;
      menu->selected_item++;

      ctk_clist_prepend_widget(CTK_CLIST(menu), widgets);
}

/* Insert and item into the specified Menu */
void ctk_menu_insert(CtkMenu* menu, CtkWidget* child, gint position)
{
      CtkWidget* widgets[2];
      widgets[0] = child;
      widgets[1] = NULL;

      menu->num_items++;
      if (menu->selected_item >= position)
	    menu->selected_item++;

      ctk_clist_insert_widget(CTK_CLIST(menu), position, widgets);
}

/* Return Selected Menu Item */
CtkMenuItem* ctk_menu_get_selected_item(CtkMenu* menu)
{
      CtkWidget* out;

      out = ctk_table_find_child(CTK_TABLE(menu), 0, 1, 
      	menu->selected_item+1, menu->selected_item+2);
      
      if (!out) 
	    return NULL;
      if (CTK_CHECK_TYPE(out, CtkTypeMenuItem))
	    return CTK_MENU_ITEM(out);

      return NULL;
}

/* Return Selected Widget */
CtkWidget* ctk_menu_get_active(CtkMenu *menu)
{
      CtkMenuItem* menuitem;

      menuitem = ctk_menu_get_selected_item(menu);
      return CTK_WIDGET(menuitem);
}

void ctk_menu_set_active(CtkMenu* menu, gint index)
{
      if (!menu)
	    return;
	
      if (index < 0) index = 0;
      if (index >= menu->num_items) index = menu->num_items - 1;

      menu->selected_item = index;
      
      ctk_clist_select_row(CTK_CLIST(menu), index, 0);
}

gint ctk_menu_get_selected_index(CtkMenu* menu)
{
	if (!menu)
	    return -1;
	
	return menu->selected_item;
}
