/* 
 * $Id: ctkwidget.h,v 1.30 2000/07/12 22:47:15 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTKWIDGET_H__
# define __CTKWIDGET_H__

#include <arr.h>

#include "ctktype.h"
#include "ctkobject.h"

/* Main Widget Structure */
struct CtkWidget_S {
	
	CtkObject object;
	
	gint width;
	gint height;
	gint col;
	gint row;
	
	gint clip_row;
	gint clip_col;
	gint clip_width;
	gint clip_height;

	gint orig_width;
	gint orig_height;
	
	gint min_width;
	gint min_height;

	arr_color_t main_col;
	arr_color_t inverse_col;
	arr_color_t shadow_col;
	arr_color_t title_col;
	arr_color_t selected_col;
	arr_color_t inv_selected_col;
	arr_color_t insensitive_col;

	gboolean xexpand;
	gboolean yexpand;
	gboolean xfill;
	gboolean yfill;
	gboolean xshrink;
	gboolean yshrink;
	gint xpadding;
	gint ypadding;
	
	gboolean changed;
	
	gboolean sensitive;	
	gboolean inversed;
	gboolean selected;

	gboolean show;
	gboolean destroyed;
	
	void (*set_min_size )(struct CtkWidget_S* widget);
	void (*set_real_size)(struct CtkWidget_S* widget);

	GNode *node;
};

#define CTK_WIDGET(obj)	CTK_CHECK_CAST((obj),CtkWidget,CtkTypeWidget)

typedef struct CtkWidget_S CtkWidget;

void ctk_widget_init(CtkWidget *widget);
void ctk_widget_show(CtkWidget *widget);
void ctk_widget_show_all(CtkWidget *widget);
void ctk_widget_hide(CtkWidget *widget);
void ctk_record_caller(const gchar* file, gint line, const gchar* caller);
void ctk_widget_destroy_helper(CtkWidget *widget);
void ctk_widget_destroy_real(CtkWidget *widget);
void ctk_widget_set_sensitive(CtkWidget *widget, gboolean sensitive);
void ctk_widget_set_uposition(CtkWidget *widget, gint x, gint y);
void ctk_widget_set_usize(CtkWidget *widget, gint width, gint height);

void ctk_widget_min_size(CtkWidget* widget);
void ctk_widget_real_size(CtkWidget* widget);

#define ctk_widget_destroy \
	( \
		ctk_record_caller(__FILE__, __LINE__, CTK_ASSERT_CALLER), \
		ctk_widget_destroy_helper \
	)

#endif
