##   -*- autoconf -*-
dnl some of the functions in this file were inspired by the code in the kde2.2.2
dnl packages. Copyright is below:
dnl    Copyright (C) 1997 Janos Farkas (chexum@shadow.banki.hu)
dnl              (C) 1997,98,99 Stephan Kulow (coolo@kde.org)

AC_DEFUN(AC_SET_PREFIX,
[
  unset CDPATH
  dnl set prefix
  if test "x$prefix" = "xNONE"; then
    prefix="/usr/local"
    ac_configure_args="$ac_configure_args --prefix $prefix"
  fi
  dnl set other variables
  kde_prefix=""
  qt_prefix=""
  pq_prefix=""
])

AC_DEFUN(AC_FIND_FILE,
[
$3=NO
for i in $2;
do
  for j in $1;
  do
    if test -r "$i/$j"; then
      $3=$i
      break 2
    fi
  done
done
])

AC_DEFUN(AC_CHECK_LIBPQ,
[
	dnl checking for libpq++ headers
	echo -n "checking for libpq++ header files..."
	headpq_check="$pq_prefix /usr/include/postgresql /usr/include/pgsql /usr/local/include/postgresql /usr/local/include/pgsql $pq_prefix/include/pgsql $pq_prefix/include/postgresql"
	AC_FIND_FILE(libpq++.h,$headpq_check,headpq_dir)
	if test -n "$headpq_dir" && test ! -r "$headpq_dir/libpq++.h"; then
		AC_MSG_ERROR([no Postgresql headers installed/found. Please install or check configuration.])
	else
		echo "$headpq_dir"
	fi

	dnl checking for libpq++ libraries
	echo -n "checking for libpq++ libraries..."
	libpq_check="$pq_prefix /usr/lib /usr/local/lib $pq_prefix/lib $pq_prefix/local/lib"
	AC_FIND_FILE(libpq++.so,$libpq_check,libpq_dir)
	if test -n "$libpq_dir" && test ! -r "$libpq_dir/libpq++.so"; then
		AC_MSG_ERROR([no Postgresql libraries installed/found. Please install or check configuration.])
	else
		echo "$libpq_dir"
	fi

	dnl checking for appropriate version of library by asserting for a particular function.
	AC_SUBST(headpq_dir)
	AC_SUBST(libpq_dir)
])

AC_DEFUN(AC_CHECK_QT,
[
	dnl checking for qt headers
	echo -n "checking for qt header files..."
	headqt_check="$qt_prefix $qt_prefix/lib/qt2 $qt_prefix/lib/qt /usr/lib/qt2 /usr/lib/qt /usr/local/qt/include /usr/include/qt /usr/include /usr/X11R6/include/X11/qt /usr/X11R6/include/qt /usr/X11R6/include/qt2"
	for dir in $headqt_check; do
		headqt_check="$headqt_check $dir/include $dir"
	done
	AC_FIND_FILE(qobject.h,$headqt_check,headqt_dir)
	if test -n "$headqt_dir" && test ! -r "$headqt_dir/qobject.h"; then
		AC_MSG_ERROR([no QT headers installed/found. Please install or check configuration.])
	else
		echo "$headqt_dir"
	fi

	dnl checking for qt libraries
	echo -n "checking for qt libraries..."
	libqt_check="$qt_prefix $qt_prefix/lib/qt2 $qt_prefix/lib/qt /usr/lib/qt2 /usr/lib/qt /usr/X11R6/lib /usr/lib /usr/local/qt/lib"
	for dir in $libqt_check; do
		libqt_check="$libqt_check $dir/lib $dir"
	done
	AC_FIND_FILE(libqt.so,$libqt_check,libqt_dir)
	if test -n "$libqt_dir" && test ! -r "$libqt_dir/libqt.so"; then
		AC_MSG_ERROR([no QT libraries installed/found. Please install or check configuration.])
	else
		echo "$libqt_dir"
	fi

	AC_SUBST(headqt_dir)
	AC_SUBST(libqt_dir)
])

AC_DEFUN(AC_CHECK_KDE,
[
	dnl checking for kde headers
	echo -n "checking for kde header files..."
	headkde_check="$kde_prefix $kde_prefix/include $kde_prefix/kde/include $kde_prefix/kde2/include /usr/lib/kde/include /usr/local/kde/include /usr/local/include /usr/kde/include /usr/include/kde /usr/include /opt/kde2/include /opt/kde/include"
	AC_FIND_FILE(kapplication.h,$headkde_check,headkde_dir)
	if test -n "$headkde_dir" && test ! -r "$headkde_dir/kapplication.h"; then
		AC_MSG_ERROR([no KDE headers installed/found. Please install or check configuration.])
	else
		echo "$headkde_dir"
	fi

	dnl checking for kde libraries
	echo -n "checking for kde libraries..."
	libkde_check="$kde_prefix $kde_prefix/lib $kde_prefix/kde/lib $kde_prefix/kde2/lib /usr/lib/kde/lib /usr/local/kde/lib /usr/kde/lib /usr/lib/kde /usr/lib /usr/X11R6/lib /usr/local/lib /opt/kde2/lib /opt/kde/lib /usr/X11R6/kde/lib"
	AC_FIND_FILE(libkdecore.so,$libkde_check,libkde_dir)
	if test -n "$libkde_dir" && test ! -r "$libkde_dir/libkdecore.so"; then
		AC_MSG_ERROR([no KDE libraries installed/found. Please install or check configuration.])
	else
		echo "$libkde_dir"
	fi

	AC_SUBST(headkde_dir)
	AC_SUBST(libkde_dir)
])

AC_DEFUN(AC_SET_DATA_PATH,
[
	DBMUSIC_DATADIR="${datadir}/libdbmusic/"
	eval DBMUSIC_TEMPPATH="$DBMUSIC_DATADIR"
	AC_DEFINE_UNQUOTED(DBMUSIC_DATADIR,"$DBMUSIC_TEMPPATH",[This is the path to the data dir which contains dbmusic.dump])
	AC_SUBST(DBMUSIC_DATADIR)
])

