/* ui-icon-chooser-dialog.c generated by valac, the Vala compiler
 * generated from ui-icon-chooser-dialog.vala, do not modify */

/*
 * Desktop Agnostic Library: Icon chooser dialog.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <build-config.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <libdesktop-agnostic/vfs.h>


#define DESKTOP_AGNOSTIC_UI_TYPE_ICON_TYPE (desktop_agnostic_ui_icon_type_get_type ())

#define DESKTOP_AGNOSTIC_UI_TYPE_ICON_CHOOSER_DIALOG (desktop_agnostic_ui_icon_chooser_dialog_get_type ())
#define DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_UI_TYPE_ICON_CHOOSER_DIALOG, DesktopAgnosticUIIconChooserDialog))
#define DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_UI_TYPE_ICON_CHOOSER_DIALOG, DesktopAgnosticUIIconChooserDialogClass))
#define DESKTOP_AGNOSTIC_UI_IS_ICON_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_UI_TYPE_ICON_CHOOSER_DIALOG))
#define DESKTOP_AGNOSTIC_UI_IS_ICON_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_UI_TYPE_ICON_CHOOSER_DIALOG))
#define DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_UI_TYPE_ICON_CHOOSER_DIALOG, DesktopAgnosticUIIconChooserDialogClass))

typedef struct _DesktopAgnosticUIIconChooserDialog DesktopAgnosticUIIconChooserDialog;
typedef struct _DesktopAgnosticUIIconChooserDialogClass DesktopAgnosticUIIconChooserDialogClass;
typedef struct _DesktopAgnosticUIIconChooserDialogPrivate DesktopAgnosticUIIconChooserDialogPrivate;

#define DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_TYPE_COLUMN (desktop_agnostic_ui_icon_chooser_dialog_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __g_list_free_gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_gtk_tree_path_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

typedef enum  {
	DESKTOP_AGNOSTIC_UI_ICON_TYPE_NONE,
	DESKTOP_AGNOSTIC_UI_ICON_TYPE_THEMED,
	DESKTOP_AGNOSTIC_UI_ICON_TYPE_FILE
} DesktopAgnosticUIIconType;

struct _DesktopAgnosticUIIconChooserDialog {
	GtkDialog parent_instance;
	DesktopAgnosticUIIconChooserDialogPrivate * priv;
};

struct _DesktopAgnosticUIIconChooserDialogClass {
	GtkDialogClass parent_class;
};

struct _DesktopAgnosticUIIconChooserDialogPrivate {
	GtkRadioButton* _file;
	GtkRadioButton* _themed;
	GtkFileChooserButton* _directory;
	GtkComboBox* _themed_context;
	GtkIconView* _file_viewer;
	GtkIconView* _themed_viewer;
	GtkIconView* _viewer;
	char* _selected_icon;
	GdkPixbuf* _selected_pixbuf;
	DesktopAgnosticUIIconType _selected_icon_type;
};

typedef enum  {
	DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_PIXBUF,
	DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_NAME,
	DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_DATA,
	DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_COUNT
} DesktopAgnosticUIIconChooserDialogColumn;


static gpointer desktop_agnostic_ui_icon_chooser_dialog_parent_class = NULL;

#define ICON_I18N_PACKAGE GETTEXT_PACKAGE
GType desktop_agnostic_ui_icon_type_get_type (void);
GType desktop_agnostic_ui_icon_chooser_dialog_get_type (void);
#define DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_UI_TYPE_ICON_CHOOSER_DIALOG, DesktopAgnosticUIIconChooserDialogPrivate))
enum  {
	DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_SELECTED_ICON,
	DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_SELECTED_PIXBUF,
	DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_SELECTED_ICON_TYPE
};
static GType desktop_agnostic_ui_icon_chooser_dialog_column_get_type (void);
static void desktop_agnostic_ui_icon_chooser_dialog_on_icon_type_toggled (DesktopAgnosticUIIconChooserDialog* self, GtkToggleButton* themed);
static void _desktop_agnostic_ui_icon_chooser_dialog_on_icon_type_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void desktop_agnostic_ui_icon_chooser_dialog_on_folder_changed (DesktopAgnosticUIIconChooserDialog* self, GtkFileChooser* chooser);
static void _desktop_agnostic_ui_icon_chooser_dialog_on_folder_changed_gtk_file_chooser_current_folder_changed (GtkFileChooser* _sender, gpointer self);
static void desktop_agnostic_ui_icon_chooser_dialog_add_icon_viewer (DesktopAgnosticUIIconChooserDialog* self, GtkIconView** viewer, gboolean themed);
static void desktop_agnostic_ui_icon_chooser_dialog_create_ui (DesktopAgnosticUIIconChooserDialog* self);
static GtkIconView* desktop_agnostic_ui_icon_chooser_dialog_create_icon_viewer (DesktopAgnosticUIIconChooserDialog* self, gboolean themed);
static GtkListStore* desktop_agnostic_ui_icon_chooser_dialog_create_model (DesktopAgnosticUIIconChooserDialog* self);
static void desktop_agnostic_ui_icon_chooser_dialog_on_icon_context_changed (DesktopAgnosticUIIconChooserDialog* self, GtkComboBox* box);
static void _desktop_agnostic_ui_icon_chooser_dialog_on_icon_context_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _g_slist_free_g_object_unref (GSList* self);
static void _g_list_free_gtk_tree_path_free (GList* self);
static void desktop_agnostic_ui_icon_chooser_dialog_set_selected_pixbuf (DesktopAgnosticUIIconChooserDialog* self, GdkPixbuf* value);
static void desktop_agnostic_ui_icon_chooser_dialog_set_selected_icon (DesktopAgnosticUIIconChooserDialog* self, const char* value);
static void desktop_agnostic_ui_icon_chooser_dialog_set_selected_icon_type (DesktopAgnosticUIIconChooserDialog* self, DesktopAgnosticUIIconType value);
static void desktop_agnostic_ui_icon_chooser_dialog_on_response (DesktopAgnosticUIIconChooserDialog* self, gint response);
DesktopAgnosticUIIconChooserDialog* desktop_agnostic_ui_icon_chooser_dialog_new (void);
DesktopAgnosticUIIconChooserDialog* desktop_agnostic_ui_icon_chooser_dialog_construct (GType object_type);
const char* desktop_agnostic_ui_icon_chooser_dialog_get_selected_icon (DesktopAgnosticUIIconChooserDialog* self);
GdkPixbuf* desktop_agnostic_ui_icon_chooser_dialog_get_selected_pixbuf (DesktopAgnosticUIIconChooserDialog* self);
DesktopAgnosticUIIconType desktop_agnostic_ui_icon_chooser_dialog_get_selected_icon_type (DesktopAgnosticUIIconChooserDialog* self);
static void _desktop_agnostic_ui_icon_chooser_dialog_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static GObject * desktop_agnostic_ui_icon_chooser_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void desktop_agnostic_ui_icon_chooser_dialog_finalize (GObject* obj);
static void desktop_agnostic_ui_icon_chooser_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_ui_icon_chooser_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);




GType desktop_agnostic_ui_icon_type_get_type (void) {
	static GType desktop_agnostic_ui_icon_type_type_id = 0;
	if (G_UNLIKELY (desktop_agnostic_ui_icon_type_type_id == 0)) {
		static const GEnumValue values[] = {{DESKTOP_AGNOSTIC_UI_ICON_TYPE_NONE, "DESKTOP_AGNOSTIC_UI_ICON_TYPE_NONE", "none"}, {DESKTOP_AGNOSTIC_UI_ICON_TYPE_THEMED, "DESKTOP_AGNOSTIC_UI_ICON_TYPE_THEMED", "themed"}, {DESKTOP_AGNOSTIC_UI_ICON_TYPE_FILE, "DESKTOP_AGNOSTIC_UI_ICON_TYPE_FILE", "file"}, {0, NULL, NULL}};
		desktop_agnostic_ui_icon_type_type_id = g_enum_register_static ("DesktopAgnosticUIIconType", values);
	}
	return desktop_agnostic_ui_icon_type_type_id;
}



static GType desktop_agnostic_ui_icon_chooser_dialog_column_get_type (void) {
	static GType desktop_agnostic_ui_icon_chooser_dialog_column_type_id = 0;
	if (G_UNLIKELY (desktop_agnostic_ui_icon_chooser_dialog_column_type_id == 0)) {
		static const GEnumValue values[] = {{DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_PIXBUF, "DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_PIXBUF", "pixbuf"}, {DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_NAME, "DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_NAME", "name"}, {DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_DATA, "DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_DATA", "data"}, {DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_COUNT, "DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_COUNT", "count"}, {0, NULL, NULL}};
		desktop_agnostic_ui_icon_chooser_dialog_column_type_id = g_enum_register_static ("DesktopAgnosticUIIconChooserDialogColumn", values);
	}
	return desktop_agnostic_ui_icon_chooser_dialog_column_type_id;
}


static void _desktop_agnostic_ui_icon_chooser_dialog_on_icon_type_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	desktop_agnostic_ui_icon_chooser_dialog_on_icon_type_toggled (self, _sender);
}


static void _desktop_agnostic_ui_icon_chooser_dialog_on_folder_changed_gtk_file_chooser_current_folder_changed (GtkFileChooser* _sender, gpointer self) {
	desktop_agnostic_ui_icon_chooser_dialog_on_folder_changed (self, _sender);
}


static void desktop_agnostic_ui_icon_chooser_dialog_create_ui (DesktopAgnosticUIIconChooserDialog* self) {
	GtkHBox* choices;
	GtkHBox* _tmp0_;
	GtkRadioButton* _tmp1_;
	GtkRadioButton* _tmp2_;
	GtkFileChooserButton* _tmp3_;
	g_return_if_fail (self != NULL);
	choices = NULL;
	choices = (_tmp0_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 5)), _g_object_unref0 (choices), _tmp0_);
	self->priv->_file = (_tmp1_ = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_mnemonic (NULL, _ ("From File"))), _g_object_unref0 (self->priv->_file), _tmp1_);
	gtk_container_add ((GtkContainer*) choices, (GtkWidget*) self->priv->_file);
	self->priv->_themed = (_tmp2_ = g_object_ref_sink ((GtkRadioButton*) gtk_radio_button_new_with_mnemonic_from_widget (self->priv->_file, _ ("From Theme"))), _g_object_unref0 (self->priv->_themed), _tmp2_);
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->_themed, FALSE);
	g_signal_connect_object ((GtkToggleButton*) self->priv->_themed, "toggled", (GCallback) _desktop_agnostic_ui_icon_chooser_dialog_on_icon_type_toggled_gtk_toggle_button_toggled, self, 0);
	gtk_container_add ((GtkContainer*) choices, (GtkWidget*) self->priv->_themed);
	gtk_box_pack_start ((GtkBox*) ((GtkDialog*) self)->vbox, (GtkWidget*) choices, FALSE, FALSE, (guint) 5);
	gtk_widget_show_all ((GtkWidget*) choices);
	self->priv->_directory = (_tmp3_ = g_object_ref_sink ((GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Select icon folder"), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER)), _g_object_unref0 (self->priv->_directory), _tmp3_);
	g_signal_connect_object ((GtkFileChooser*) self->priv->_directory, "current-folder-changed", (GCallback) _desktop_agnostic_ui_icon_chooser_dialog_on_folder_changed_gtk_file_chooser_current_folder_changed, self, 0);
	gtk_box_pack_start ((GtkBox*) ((GtkDialog*) self)->vbox, (GtkWidget*) self->priv->_directory, FALSE, FALSE, (guint) 5);
	gtk_widget_show ((GtkWidget*) self->priv->_directory);
	desktop_agnostic_ui_icon_chooser_dialog_add_icon_viewer (self, &self->priv->_file_viewer, FALSE);
	gtk_widget_show_all ((GtkWidget*) gtk_widget_get_parent ((GtkWidget*) self->priv->_file_viewer));
	self->priv->_viewer = self->priv->_file_viewer;
	desktop_agnostic_ui_icon_chooser_dialog_on_folder_changed (self, (GtkFileChooser*) self->priv->_directory);
	gtk_dialog_add_buttons ((GtkDialog*) self, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);
	_g_object_unref0 (choices);
}


static void desktop_agnostic_ui_icon_chooser_dialog_add_icon_viewer (DesktopAgnosticUIIconChooserDialog* self, GtkIconView** viewer, gboolean themed) {
	GtkScrolledWindow* scrolled;
	GtkScrolledWindow* _tmp0_;
	GtkIconView* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (viewer != NULL);
	scrolled = NULL;
	scrolled = (_tmp0_ = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL)), _g_object_unref0 (scrolled), _tmp0_);
	gtk_scrolled_window_set_policy (scrolled, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	*viewer = (_tmp1_ = desktop_agnostic_ui_icon_chooser_dialog_create_icon_viewer (self, themed), _g_object_unref0 (*viewer), _tmp1_);
	gtk_widget_show ((GtkWidget*) (*viewer));
	gtk_container_add ((GtkContainer*) scrolled, (GtkWidget*) (*viewer));
	gtk_box_pack_start ((GtkBox*) ((GtkDialog*) self)->vbox, (GtkWidget*) scrolled, TRUE, TRUE, (guint) 5);
	_g_object_unref0 (scrolled);
}


static GtkIconView* desktop_agnostic_ui_icon_chooser_dialog_create_icon_viewer (DesktopAgnosticUIIconChooserDialog* self, gboolean themed) {
	GtkIconView* result;
	GtkIconView* viewer;
	GtkCellRendererPixbuf* cell_pixbuf;
	GtkCellRendererText* cell_text;
	GtkIconView* _tmp1_;
	GtkListStore* _tmp0_;
	GtkCellRendererPixbuf* _tmp2_;
	GtkCellRendererText* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	viewer = NULL;
	cell_pixbuf = NULL;
	cell_text = NULL;
	viewer = (_tmp1_ = g_object_ref_sink ((GtkIconView*) gtk_icon_view_new_with_model ((GtkTreeModel*) (_tmp0_ = desktop_agnostic_ui_icon_chooser_dialog_create_model (self)))), _g_object_unref0 (viewer), _tmp1_);
	_g_object_unref0 (_tmp0_);
	gtk_icon_view_set_item_width (viewer, 72);
	gtk_icon_view_set_columns (viewer, 4);
	gtk_icon_view_set_column_spacing (viewer, 5);
	gtk_widget_set_size_request ((GtkWidget*) viewer, 325, 300);
	gtk_icon_view_set_tooltip_column (viewer, (gint) DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_DATA);
	cell_pixbuf = (_tmp2_ = g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ()), _g_object_unref0 (cell_pixbuf), _tmp2_);
	g_object_set ((GtkCellRenderer*) cell_pixbuf, "xalign", 0.5f, NULL);
	g_object_set ((GtkCellRenderer*) cell_pixbuf, "yalign", 0.5f, NULL);
	g_object_set ((GtkCellRenderer*) cell_pixbuf, "width", 48, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) viewer, (GtkCellRenderer*) cell_pixbuf, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) viewer, (GtkCellRenderer*) cell_pixbuf, "pixbuf", (gint) DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_PIXBUF);
	cell_text = (_tmp3_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (cell_text), _tmp3_);
	g_object_set ((GtkCellRenderer*) cell_text, "xalign", 0.5f, NULL);
	g_object_set ((GtkCellRenderer*) cell_text, "yalign", (float) 0, NULL);
	g_object_set (cell_text, "wrap-mode", PANGO_WRAP_WORD, NULL);
	g_object_set (cell_text, "wrap-width", 72, NULL);
	g_object_set ((GtkCellRenderer*) cell_text, "width", 72, NULL);
	g_object_set (cell_text, "ellipsize", PANGO_ELLIPSIZE_START, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) viewer, (GtkCellRenderer*) cell_text, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) viewer, (GtkCellRenderer*) cell_text, "text", 1);
	gtk_icon_view_set_selection_mode (viewer, GTK_SELECTION_SINGLE);
	result = viewer;
	_g_object_unref0 (cell_pixbuf);
	_g_object_unref0 (cell_text);
	return result;
}


static GtkListStore* desktop_agnostic_ui_icon_chooser_dialog_create_model (DesktopAgnosticUIIconChooserDialog* self) {
	GtkListStore* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = gtk_list_store_new ((gint) DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_COUNT, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING, NULL);
	return result;
}


static void _desktop_agnostic_ui_icon_chooser_dialog_on_icon_context_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	desktop_agnostic_ui_icon_chooser_dialog_on_icon_context_changed (self, _sender);
}


static void desktop_agnostic_ui_icon_chooser_dialog_on_icon_type_toggled (DesktopAgnosticUIIconChooserDialog* self, GtkToggleButton* themed) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (themed != NULL);
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->_themed)) {
		if (self->priv->_themed_viewer == NULL) {
			GtkIconTheme* icon_theme;
			GList* context_list;
			GtkComboBox* _tmp0_;
			icon_theme = NULL;
			context_list = NULL;
			self->priv->_themed_context = (_tmp0_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_text ()), _g_object_unref0 (self->priv->_themed_context), _tmp0_);
			g_signal_connect_object (self->priv->_themed_context, "changed", (GCallback) _desktop_agnostic_ui_icon_chooser_dialog_on_icon_context_changed_gtk_combo_box_changed, self, 0);
			gtk_box_pack_start ((GtkBox*) ((GtkDialog*) self)->vbox, (GtkWidget*) self->priv->_themed_context, FALSE, FALSE, (guint) 5);
			desktop_agnostic_ui_icon_chooser_dialog_add_icon_viewer (self, &self->priv->_themed_viewer, TRUE);
			icon_theme = gtk_icon_theme_get_default ();
			context_list = gtk_icon_theme_list_contexts (icon_theme);
			context_list = g_list_sort (context_list, (GCompareFunc) strcmp);
			{
				GList* context_collection;
				GList* context_it;
				context_collection = context_list;
				for (context_it = context_collection; context_it != NULL; context_it = context_it->next) {
					const char* context;
					context = (const char*) context_it->data;
					{
						gtk_combo_box_append_text (self->priv->_themed_context, context);
					}
				}
			}
		}
		gtk_widget_hide ((GtkWidget*) gtk_widget_get_parent ((GtkWidget*) self->priv->_file_viewer));
		gtk_widget_hide ((GtkWidget*) self->priv->_directory);
		gtk_widget_show ((GtkWidget*) gtk_widget_get_parent ((GtkWidget*) self->priv->_themed_viewer));
		gtk_widget_show ((GtkWidget*) self->priv->_themed_context);
		self->priv->_viewer = self->priv->_themed_viewer;
	} else {
		gtk_widget_hide ((GtkWidget*) gtk_widget_get_parent ((GtkWidget*) self->priv->_themed_viewer));
		gtk_widget_hide ((GtkWidget*) self->priv->_themed_context);
		gtk_widget_show ((GtkWidget*) gtk_widget_get_parent ((GtkWidget*) self->priv->_file_viewer));
		gtk_widget_show ((GtkWidget*) self->priv->_directory);
		self->priv->_viewer = self->priv->_file_viewer;
	}
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static void desktop_agnostic_ui_icon_chooser_dialog_on_folder_changed (DesktopAgnosticUIIconChooserDialog* self, GtkFileChooser* chooser) {
	GError * _inner_error_;
	GtkListStore* model;
	char* uri;
	DesktopAgnosticVFSFile* directory;
	GSList* children;
	GtkTreeModel* _tmp0_;
	char* _tmp1_;
	DesktopAgnosticVFSFile* _tmp2_;
	DesktopAgnosticVFSFile* _tmp3_;
	GSList* _tmp4_;
	GSList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (chooser != NULL);
	_inner_error_ = NULL;
	model = NULL;
	uri = NULL;
	directory = NULL;
	children = NULL;
	model = (_tmp0_ = gtk_icon_view_get_model (self->priv->_file_viewer), GTK_IS_LIST_STORE (_tmp0_) ? ((GtkListStore*) _tmp0_) : NULL);
	gtk_list_store_clear (model);
	uri = (_tmp1_ = gtk_file_chooser_get_uri (chooser), _g_free0 (uri), _tmp1_);
	_tmp2_ = desktop_agnostic_vfs_file_new_for_uri (uri, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (uri);
		_g_object_unref0 (directory);
		__g_slist_free_g_object_unref0 (children);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	directory = (_tmp3_ = _tmp2_, _g_object_unref0 (directory), _tmp3_);
	_tmp4_ = desktop_agnostic_vfs_file_enumerate_children (directory, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (uri);
		_g_object_unref0 (directory);
		__g_slist_free_g_object_unref0 (children);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	children = (_tmp5_ = _tmp4_, __g_slist_free_g_object_unref0 (children), _tmp5_);
	{
		GSList* child_collection;
		GSList* child_it;
		child_collection = children;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			DesktopAgnosticVFSFile* child;
			child = (DesktopAgnosticVFSFile*) child_it->data;
			{
				char* path;
				char* path_down;
				char* _tmp6_;
				char* _tmp7_;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				path = NULL;
				path_down = NULL;
				path = (_tmp6_ = desktop_agnostic_vfs_file_get_path (child), _g_free0 (path), _tmp6_);
				path_down = (_tmp7_ = g_utf8_strdown (path, -1), _g_free0 (path_down), _tmp7_);
				if (g_str_has_suffix (path_down, ".png")) {
					_tmp11_ = TRUE;
				} else {
					_tmp11_ = g_str_has_suffix (path_down, ".svg");
				}
				if (_tmp11_) {
					_tmp10_ = TRUE;
				} else {
					_tmp10_ = g_str_has_suffix (path_down, ".jpg");
				}
				if (_tmp10_) {
					_tmp9_ = TRUE;
				} else {
					_tmp9_ = g_str_has_suffix (path_down, ".jpeg");
				}
				if (_tmp9_) {
					_tmp8_ = TRUE;
				} else {
					_tmp8_ = g_str_has_suffix (path_down, ".xpm");
				}
				if (_tmp8_) {
					{
						GtkTreeIter iter = {0};
						GdkPixbuf* pixbuf;
						GdkPixbuf* _tmp12_;
						GdkPixbuf* _tmp13_;
						char* _tmp14_;
						pixbuf = NULL;
						_tmp12_ = gdk_pixbuf_new_from_file_at_scale (path, 48, -1, TRUE, &_inner_error_);
						if (_inner_error_ != NULL) {
							_g_object_unref0 (pixbuf);
							if (_inner_error_->domain == G_FILE_ERROR) {
								goto __catch0_g_file_error;
							}
							goto __catch0_g_error;
						}
						pixbuf = (_tmp13_ = _tmp12_, _g_object_unref0 (pixbuf), _tmp13_);
						gtk_list_store_append (model, &iter);
						gtk_list_store_set (model, &iter, DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_PIXBUF, pixbuf, DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_NAME, _tmp14_ = g_path_get_basename (path), DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_DATA, path, -1);
						_g_free0 (_tmp14_);
						_g_object_unref0 (pixbuf);
					}
					goto __finally0;
					__catch0_g_file_error:
					{
						GError * err;
						err = _inner_error_;
						_inner_error_ = NULL;
						{
							_g_error_free0 (err);
						}
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError * err;
						err = _inner_error_;
						_inner_error_ = NULL;
						{
							g_warning ("ui-icon-chooser-dialog.vala:238: GDK Pixbuf error (%s): %s", path, err->message);
							_g_error_free0 (err);
						}
					}
					__finally0:
					if (_inner_error_ != NULL) {
						_g_free0 (path);
						_g_free0 (path_down);
						_g_free0 (uri);
						_g_object_unref0 (directory);
						__g_slist_free_g_object_unref0 (children);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_g_free0 (path);
				_g_free0 (path_down);
			}
		}
	}
	_g_free0 (uri);
	_g_object_unref0 (directory);
	__g_slist_free_g_object_unref0 (children);
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void desktop_agnostic_ui_icon_chooser_dialog_on_icon_context_changed (DesktopAgnosticUIIconChooserDialog* self, GtkComboBox* box) {
	GError * _inner_error_;
	GtkListStore* model;
	GtkIconTheme* icon_theme;
	GList* icon_list;
	GtkTreeModel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	_inner_error_ = NULL;
	model = NULL;
	icon_theme = NULL;
	icon_list = NULL;
	model = (_tmp0_ = gtk_icon_view_get_model (self->priv->_themed_viewer), GTK_IS_LIST_STORE (_tmp0_) ? ((GtkListStore*) _tmp0_) : NULL);
	gtk_list_store_clear (model);
	icon_theme = gtk_icon_theme_get_default ();
	icon_list = gtk_icon_theme_list_icons (icon_theme, gtk_combo_box_get_active_text (box));
	icon_list = g_list_sort (icon_list, (GCompareFunc) strcmp);
	{
		GList* icon_name_collection;
		GList* icon_name_it;
		icon_name_collection = icon_list;
		for (icon_name_it = icon_name_collection; icon_name_it != NULL; icon_name_it = icon_name_it->next) {
			const char* icon_name;
			icon_name = (const char*) icon_name_it->data;
			{
				{
					GtkIconInfo* info;
					GdkPixbuf* pixbuf;
					char* name;
					GtkTreeIter iter = {0};
					GtkIconInfo* _tmp1_;
					GdkPixbuf* _tmp2_;
					GdkPixbuf* _tmp3_;
					char* _tmp4_;
					info = NULL;
					pixbuf = NULL;
					name = NULL;
					info = (_tmp1_ = gtk_icon_theme_lookup_icon (icon_theme, icon_name, 48, 0), _gtk_icon_info_free0 (info), _tmp1_);
					_tmp2_ = gtk_icon_info_load_icon (info, &_inner_error_);
					if (_inner_error_ != NULL) {
						_gtk_icon_info_free0 (info);
						_g_object_unref0 (pixbuf);
						_g_free0 (name);
						goto __catch1_g_error;
					}
					pixbuf = (_tmp3_ = _tmp2_, _g_object_unref0 (pixbuf), _tmp3_);
					name = (_tmp4_ = g_strdup (gtk_icon_info_get_display_name (info)), _g_free0 (name), _tmp4_);
					if (name == NULL) {
						char* _tmp5_;
						name = (_tmp5_ = string_replace (icon_name, "-", " "), _g_free0 (name), _tmp5_);
					}
					gtk_list_store_append (model, &iter);
					gtk_list_store_set (model, &iter, DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_PIXBUF, pixbuf, DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_NAME, name, DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_DATA, icon_name, -1);
					_gtk_icon_info_free0 (info);
					_g_object_unref0 (pixbuf);
					_g_free0 (name);
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError * err;
					err = _inner_error_;
					_inner_error_ = NULL;
					{
						g_warning ("ui-icon-chooser-dialog.vala:280: Could not load %s: %s", icon_name, err->message);
						_g_error_free0 (err);
					}
				}
				__finally1:
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void _g_list_free_gtk_tree_path_free (GList* self) {
	g_list_foreach (self, (GFunc) gtk_tree_path_free, NULL);
	g_list_free (self);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void desktop_agnostic_ui_icon_chooser_dialog_on_response (DesktopAgnosticUIIconChooserDialog* self, gint response) {
	g_return_if_fail (self != NULL);
	if (response == GTK_RESPONSE_OK) {
		GList* item;
		GList* _tmp0_;
		item = NULL;
		item = (_tmp0_ = gtk_icon_view_get_selected_items (self->priv->_viewer), __g_list_free_gtk_tree_path_free0 (item), _tmp0_);
		if (item == NULL) {
			char* msg;
			GtkMessageDialog* dialog;
			char* _tmp1_;
			GtkMessageDialog* _tmp2_;
			msg = NULL;
			dialog = NULL;
			msg = (_tmp1_ = g_strdup (_ ("Please select an icon.")), _g_free0 (msg), _tmp1_);
			dialog = (_tmp2_ = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, msg)), _g_object_unref0 (dialog), _tmp2_);
			gtk_window_set_title ((GtkWindow*) dialog, _ ("Error"));
			gtk_dialog_run ((GtkDialog*) dialog);
			gtk_object_destroy ((GtkObject*) dialog);
			_g_free0 (msg);
			_g_object_unref0 (dialog);
			__g_list_free_gtk_tree_path_free0 (item);
			return;
		} else {
			GtkTreePath* path;
			GtkTreeModel* model;
			gboolean res = FALSE;
			GtkTreeIter iter = {0};
			GtkTreePath* _tmp3_;
			GtkTreeModel* _tmp4_;
			path = NULL;
			model = NULL;
			path = (_tmp3_ = _gtk_tree_path_copy0 ((GtkTreePath*) item->data), _gtk_tree_path_free0 (path), _tmp3_);
			model = (_tmp4_ = _g_object_ref0 (gtk_icon_view_get_model (self->priv->_viewer)), _g_object_unref0 (model), _tmp4_);
			res = gtk_tree_model_get_iter (model, &iter, path);
			if (res) {
				GValue pixbuf = {0};
				GValue data = {0};
				GValue _tmp6_;
				GValue _tmp5_ = {0};
				GValue _tmp8_;
				GValue _tmp7_ = {0};
				gtk_tree_model_get_value (model, &iter, (gint) DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_PIXBUF, &_tmp5_);
				pixbuf = (_tmp6_ = _tmp5_, G_IS_VALUE (&pixbuf) ? (g_value_unset (&pixbuf), NULL) : NULL, _tmp6_);
				gtk_tree_model_get_value (model, &iter, (gint) DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_COLUMN_DATA, &_tmp7_);
				data = (_tmp8_ = _tmp7_, G_IS_VALUE (&data) ? (g_value_unset (&data), NULL) : NULL, _tmp8_);
				desktop_agnostic_ui_icon_chooser_dialog_set_selected_pixbuf (self, g_value_get_object (&pixbuf));
				desktop_agnostic_ui_icon_chooser_dialog_set_selected_icon (self, g_value_get_string (&data));
				if (self->priv->_viewer == self->priv->_file_viewer) {
					desktop_agnostic_ui_icon_chooser_dialog_set_selected_icon_type (self, DESKTOP_AGNOSTIC_UI_ICON_TYPE_FILE);
				} else {
					desktop_agnostic_ui_icon_chooser_dialog_set_selected_icon_type (self, DESKTOP_AGNOSTIC_UI_ICON_TYPE_THEMED);
				}
				g_signal_emit_by_name (self, "icon-selected");
				G_IS_VALUE (&pixbuf) ? (g_value_unset (&pixbuf), NULL) : NULL;
				G_IS_VALUE (&data) ? (g_value_unset (&data), NULL) : NULL;
			} else {
				g_warning ("ui-icon-chooser-dialog.vala:340: Something wrong happened when converting tree path -> iter.");
			}
			_gtk_tree_path_free0 (path);
			_g_object_unref0 (model);
		}
		__g_list_free_gtk_tree_path_free0 (item);
	}
	gtk_widget_hide ((GtkWidget*) self);
}


DesktopAgnosticUIIconChooserDialog* desktop_agnostic_ui_icon_chooser_dialog_construct (GType object_type) {
	DesktopAgnosticUIIconChooserDialog * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DesktopAgnosticUIIconChooserDialog* desktop_agnostic_ui_icon_chooser_dialog_new (void) {
	return desktop_agnostic_ui_icon_chooser_dialog_construct (DESKTOP_AGNOSTIC_UI_TYPE_ICON_CHOOSER_DIALOG);
}


const char* desktop_agnostic_ui_icon_chooser_dialog_get_selected_icon (DesktopAgnosticUIIconChooserDialog* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_selected_icon;
	return result;
}


static void desktop_agnostic_ui_icon_chooser_dialog_set_selected_icon (DesktopAgnosticUIIconChooserDialog* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_selected_icon = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_selected_icon), _tmp0_);
	g_object_notify ((GObject *) self, "selected-icon");
}


GdkPixbuf* desktop_agnostic_ui_icon_chooser_dialog_get_selected_pixbuf (DesktopAgnosticUIIconChooserDialog* self) {
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_selected_pixbuf;
	return result;
}


static void desktop_agnostic_ui_icon_chooser_dialog_set_selected_pixbuf (DesktopAgnosticUIIconChooserDialog* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_selected_pixbuf = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_selected_pixbuf), _tmp0_);
	g_object_notify ((GObject *) self, "selected-pixbuf");
}


DesktopAgnosticUIIconType desktop_agnostic_ui_icon_chooser_dialog_get_selected_icon_type (DesktopAgnosticUIIconChooserDialog* self) {
	DesktopAgnosticUIIconType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_selected_icon_type;
	return result;
}


static void desktop_agnostic_ui_icon_chooser_dialog_set_selected_icon_type (DesktopAgnosticUIIconChooserDialog* self, DesktopAgnosticUIIconType value) {
	g_return_if_fail (self != NULL);
	self->priv->_selected_icon_type = value;
	g_object_notify ((GObject *) self, "selected-icon-type");
}


static void _desktop_agnostic_ui_icon_chooser_dialog_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	desktop_agnostic_ui_icon_chooser_dialog_on_response (self, response_id);
}


static GObject * desktop_agnostic_ui_icon_chooser_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DesktopAgnosticUIIconChooserDialog * self;
	parent_class = G_OBJECT_CLASS (desktop_agnostic_ui_icon_chooser_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG (obj);
	{
		g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _desktop_agnostic_ui_icon_chooser_dialog_on_response_gtk_dialog_response, self, 0);
		gtk_window_set_title ((GtkWindow*) self, _ ("Select Icon"));
		gtk_window_set_icon_name ((GtkWindow*) self, GTK_STOCK_FIND);
		desktop_agnostic_ui_icon_chooser_dialog_create_ui (self);
	}
	return obj;
}


static void desktop_agnostic_ui_icon_chooser_dialog_class_init (DesktopAgnosticUIIconChooserDialogClass * klass) {
	desktop_agnostic_ui_icon_chooser_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticUIIconChooserDialogPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_ui_icon_chooser_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_ui_icon_chooser_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = desktop_agnostic_ui_icon_chooser_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_ui_icon_chooser_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_SELECTED_ICON, g_param_spec_string ("selected-icon", "selected-icon", "selected-icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_SELECTED_PIXBUF, g_param_spec_object ("selected-pixbuf", "selected-pixbuf", "selected-pixbuf", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_SELECTED_ICON_TYPE, g_param_spec_enum ("selected-icon-type", "selected-icon-type", "selected-icon-type", DESKTOP_AGNOSTIC_UI_TYPE_ICON_TYPE, DESKTOP_AGNOSTIC_UI_ICON_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("icon_selected", DESKTOP_AGNOSTIC_UI_TYPE_ICON_CHOOSER_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void desktop_agnostic_ui_icon_chooser_dialog_instance_init (DesktopAgnosticUIIconChooserDialog * self) {
	self->priv = DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_GET_PRIVATE (self);
	self->priv->_themed_viewer = NULL;
	self->priv->_selected_icon = NULL;
	self->priv->_selected_pixbuf = NULL;
	self->priv->_selected_icon_type = DESKTOP_AGNOSTIC_UI_ICON_TYPE_NONE;
}


static void desktop_agnostic_ui_icon_chooser_dialog_finalize (GObject* obj) {
	DesktopAgnosticUIIconChooserDialog * self;
	self = DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG (obj);
	_g_object_unref0 (self->priv->_file);
	_g_object_unref0 (self->priv->_themed);
	_g_object_unref0 (self->priv->_directory);
	_g_object_unref0 (self->priv->_themed_context);
	_g_object_unref0 (self->priv->_file_viewer);
	_g_object_unref0 (self->priv->_themed_viewer);
	_g_free0 (self->priv->_selected_icon);
	_g_object_unref0 (self->priv->_selected_pixbuf);
	G_OBJECT_CLASS (desktop_agnostic_ui_icon_chooser_dialog_parent_class)->finalize (obj);
}


GType desktop_agnostic_ui_icon_chooser_dialog_get_type (void) {
	static GType desktop_agnostic_ui_icon_chooser_dialog_type_id = 0;
	if (desktop_agnostic_ui_icon_chooser_dialog_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticUIIconChooserDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_ui_icon_chooser_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticUIIconChooserDialog), 0, (GInstanceInitFunc) desktop_agnostic_ui_icon_chooser_dialog_instance_init, NULL };
		desktop_agnostic_ui_icon_chooser_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "DesktopAgnosticUIIconChooserDialog", &g_define_type_info, 0);
	}
	return desktop_agnostic_ui_icon_chooser_dialog_type_id;
}


static void desktop_agnostic_ui_icon_chooser_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticUIIconChooserDialog * self;
	self = DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_SELECTED_ICON:
		g_value_set_string (value, desktop_agnostic_ui_icon_chooser_dialog_get_selected_icon (self));
		break;
		case DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_SELECTED_PIXBUF:
		g_value_set_object (value, desktop_agnostic_ui_icon_chooser_dialog_get_selected_pixbuf (self));
		break;
		case DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_SELECTED_ICON_TYPE:
		g_value_set_enum (value, desktop_agnostic_ui_icon_chooser_dialog_get_selected_icon_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_ui_icon_chooser_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticUIIconChooserDialog * self;
	self = DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_SELECTED_ICON:
		desktop_agnostic_ui_icon_chooser_dialog_set_selected_icon (self, g_value_get_string (value));
		break;
		case DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_SELECTED_PIXBUF:
		desktop_agnostic_ui_icon_chooser_dialog_set_selected_pixbuf (self, g_value_get_object (value));
		break;
		case DESKTOP_AGNOSTIC_UI_ICON_CHOOSER_DIALOG_SELECTED_ICON_TYPE:
		desktop_agnostic_ui_icon_chooser_dialog_set_selected_icon_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




