/* vfs-file-impl-thunar-vfs.c generated by valac, the Vala compiler
 * generated from vfs-file-impl-thunar-vfs.vala, do not modify */

/*
 * Desktop Agnostic Library: File implementation (with Thunar VFS).
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <thunar-vfs/thunar-vfs.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS (desktop_agnostic_vfs_file_thunar_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS, DesktopAgnosticVFSFileThunarVFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS, DesktopAgnosticVFSFileThunarVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS, DesktopAgnosticVFSFileThunarVFSClass))

typedef struct _DesktopAgnosticVFSFileThunarVFS DesktopAgnosticVFSFileThunarVFS;
typedef struct _DesktopAgnosticVFSFileThunarVFSClass DesktopAgnosticVFSFileThunarVFSClass;
typedef struct _DesktopAgnosticVFSFileThunarVFSPrivate DesktopAgnosticVFSFileThunarVFSPrivate;
#define _thunar_vfs_path_unref0(var) ((var == NULL) ? NULL : (var = (thunar_vfs_path_unref (var), NULL)))
#define _thunar_vfs_info_unref0(var) ((var == NULL) ? NULL : (var = (thunar_vfs_info_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_THUNAR_VFS (desktop_agnostic_vfs_file_monitor_thunar_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_THUNAR_VFS, DesktopAgnosticVFSFileMonitorThunarVFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_THUNAR_VFS, DesktopAgnosticVFSFileMonitorThunarVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_THUNAR_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_THUNAR_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_THUNAR_VFS))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_THUNAR_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_THUNAR_VFS, DesktopAgnosticVFSFileMonitorThunarVFSClass))

typedef struct _DesktopAgnosticVFSFileMonitorThunarVFS DesktopAgnosticVFSFileMonitorThunarVFS;
typedef struct _DesktopAgnosticVFSFileMonitorThunarVFSClass DesktopAgnosticVFSFileMonitorThunarVFSClass;
#define __g_list_free_thunar_vfs_path_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_thunar_vfs_path_unref (var), NULL)))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DesktopAgnosticVFSFileThunarVFS {
	DesktopAgnosticVFSFile parent_instance;
	DesktopAgnosticVFSFileThunarVFSPrivate * priv;
};

struct _DesktopAgnosticVFSFileThunarVFSClass {
	DesktopAgnosticVFSFileClass parent_class;
};

struct _DesktopAgnosticVFSFileThunarVFSPrivate {
	ThunarVfsPath* _path;
	ThunarVfsInfo* _info;
	char* _uri;
};


static gpointer desktop_agnostic_vfs_file_thunar_vfs_parent_class = NULL;

GType desktop_agnostic_vfs_file_thunar_vfs_get_type (void);
#define DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS, DesktopAgnosticVFSFileThunarVFSPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_IMPLEMENTATION,
	DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_IMPL_PATH,
	DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_IMPL_URI,
	DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_FILE_TYPE,
	DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_PARENT
};
static void desktop_agnostic_vfs_file_thunar_vfs_real_init (DesktopAgnosticVFSFile* base, const char* uri);
static gboolean desktop_agnostic_vfs_file_thunar_vfs_real_exists (DesktopAgnosticVFSFile* base);
DesktopAgnosticVFSFileMonitorThunarVFS* desktop_agnostic_vfs_file_monitor_thunar_vfs_new (DesktopAgnosticVFSFileThunarVFS* file);
DesktopAgnosticVFSFileMonitorThunarVFS* desktop_agnostic_vfs_file_monitor_thunar_vfs_construct (GType object_type, DesktopAgnosticVFSFileThunarVFS* file);
GType desktop_agnostic_vfs_file_monitor_thunar_vfs_get_type (void);
static DesktopAgnosticVFSFileMonitor* desktop_agnostic_vfs_file_thunar_vfs_real_monitor (DesktopAgnosticVFSFile* base);
static gboolean desktop_agnostic_vfs_file_thunar_vfs_real_load_contents (DesktopAgnosticVFSFile* base, char** contents, gsize* length, GError** error);
static gboolean desktop_agnostic_vfs_file_thunar_vfs_real_replace_contents (DesktopAgnosticVFSFile* base, const char* contents, GError** error);
static void _g_list_free_thunar_vfs_path_unref (GList* self);
static gboolean desktop_agnostic_vfs_file_thunar_vfs_real_launch (DesktopAgnosticVFSFile* base, GError** error);
static void _g_slist_free_g_object_unref (GSList* self);
static GSList* desktop_agnostic_vfs_file_thunar_vfs_real_enumerate_children (DesktopAgnosticVFSFile* base, GError** error);
static gboolean desktop_agnostic_vfs_file_thunar_vfs_real_copy (DesktopAgnosticVFSFile* base, DesktopAgnosticVFSFile* destination, gboolean overwrite, GError** error);
static gboolean desktop_agnostic_vfs_file_thunar_vfs_real_remove (DesktopAgnosticVFSFile* base, GError** error);
DesktopAgnosticVFSFileThunarVFS* desktop_agnostic_vfs_file_thunar_vfs_new (void);
DesktopAgnosticVFSFileThunarVFS* desktop_agnostic_vfs_file_thunar_vfs_construct (GType object_type);
static void desktop_agnostic_vfs_file_thunar_vfs_finalize (GObject* obj);
static void desktop_agnostic_vfs_file_thunar_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);



static void desktop_agnostic_vfs_file_thunar_vfs_real_init (DesktopAgnosticVFSFile* base, const char* uri) {
	DesktopAgnosticVFSFileThunarVFS * self;
	GError * _inner_error_;
	char* _tmp0_;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	g_return_if_fail (uri != NULL);
	_inner_error_ = NULL;
	self->priv->_uri = (_tmp0_ = g_strdup (uri), _g_free0 (self->priv->_uri), _tmp0_);
	{
		ThunarVfsPath* _tmp1_;
		ThunarVfsPath* _tmp2_;
		_tmp1_ = thunar_vfs_path_new (self->priv->_uri, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		self->priv->_path = (_tmp2_ = _tmp1_, _thunar_vfs_path_unref0 (self->priv->_path), _tmp2_);
		{
			ThunarVfsInfo* _tmp3_;
			ThunarVfsInfo* _tmp4_;
			_tmp3_ = thunar_vfs_info_new_for_path (self->priv->_path, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch1_g_file_error;
				}
				goto __finally1;
			}
			self->priv->_info = (_tmp4_ = _tmp3_, _thunar_vfs_info_unref0 (self->priv->_info), _tmp4_);
		}
		goto __finally1;
		__catch1_g_file_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				ThunarVfsInfo* _tmp5_;
				self->priv->_info = (_tmp5_ = NULL, _thunar_vfs_info_unref0 (self->priv->_info), _tmp5_);
				_g_error_free0 (err);
			}
		}
		__finally1:
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("vfs-file-impl-thunar-vfs.vala:156: VFS File Error (Thunar VFS): %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean desktop_agnostic_vfs_file_thunar_vfs_real_exists (DesktopAgnosticVFSFile* base) {
	DesktopAgnosticVFSFileThunarVFS * self;
	gboolean result;
	char* _tmp0_;
	gboolean _tmp1_;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	result = (_tmp1_ = g_file_test (_tmp0_ = desktop_agnostic_vfs_file_get_path ((DesktopAgnosticVFSFile*) self), G_FILE_TEST_EXISTS), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static DesktopAgnosticVFSFileMonitor* desktop_agnostic_vfs_file_thunar_vfs_real_monitor (DesktopAgnosticVFSFile* base) {
	DesktopAgnosticVFSFileThunarVFS * self;
	DesktopAgnosticVFSFileMonitor* result;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	result = (DesktopAgnosticVFSFileMonitor*) desktop_agnostic_vfs_file_monitor_thunar_vfs_new (self);
	return result;
}


static gboolean desktop_agnostic_vfs_file_thunar_vfs_real_load_contents (DesktopAgnosticVFSFile* base, char** contents, gsize* length, GError** error) {
	DesktopAgnosticVFSFileThunarVFS * self;
	gboolean result;
	GError * _inner_error_;
	char* _tmp3_;
	gboolean _tmp2_;
	char* _tmp1_ = NULL;
	char* _tmp0_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	if (contents != NULL) {
		*contents = NULL;
	}
	_inner_error_ = NULL;
	_tmp5_ = (_tmp4_ = (_tmp2_ = g_file_get_contents (_tmp0_ = desktop_agnostic_vfs_file_get_impl_path ((DesktopAgnosticVFSFile*) self), &_tmp1_, length, &_inner_error_), *contents = (_tmp3_ = _tmp1_, _g_free0 (*contents), _tmp3_), _tmp2_), _g_free0 (_tmp0_), _tmp4_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp5_;
	return result;
}


static gboolean desktop_agnostic_vfs_file_thunar_vfs_real_replace_contents (DesktopAgnosticVFSFile* base, const char* contents, GError** error) {
	DesktopAgnosticVFSFileThunarVFS * self;
	gboolean result;
	GError * _inner_error_;
	char* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	g_return_val_if_fail (contents != NULL, FALSE);
	_inner_error_ = NULL;
	_tmp2_ = (_tmp1_ = g_file_set_contents (_tmp0_ = desktop_agnostic_vfs_file_get_impl_path ((DesktopAgnosticVFSFile*) self), contents, -1, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp2_;
	return result;
}


static void _g_list_free_thunar_vfs_path_unref (GList* self) {
	g_list_foreach (self, (GFunc) thunar_vfs_path_unref, NULL);
	g_list_free (self);
}


static gpointer _thunar_vfs_path_ref0 (gpointer self) {
	return self ? thunar_vfs_path_ref (self) : NULL;
}


static gboolean desktop_agnostic_vfs_file_thunar_vfs_real_launch (DesktopAgnosticVFSFile* base, GError** error) {
	DesktopAgnosticVFSFileThunarVFS * self;
	gboolean result;
	GError * _inner_error_;
	ThunarVfsMimeDatabase* mime_db;
	ThunarVfsInfo* info;
	ThunarVfsMimeApplication* mime_app;
	GList* paths;
	ThunarVfsInfo* _tmp0_;
	ThunarVfsInfo* _tmp1_;
	gboolean _tmp2_;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	_inner_error_ = NULL;
	mime_db = NULL;
	info = NULL;
	mime_app = NULL;
	paths = NULL;
	mime_db = thunar_vfs_mime_database_get_default ();
	_tmp0_ = thunar_vfs_info_new_for_path (self->priv->_path, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_thunar_vfs_info_unref0 (info);
		__g_list_free_thunar_vfs_path_unref0 (paths);
		return FALSE;
	}
	info = (_tmp1_ = _tmp0_, _thunar_vfs_info_unref0 (info), _tmp1_);
	mime_app = thunar_vfs_mime_database_get_default_application (mime_db, info->mime_info);
	paths = g_list_append (paths, _thunar_vfs_path_ref0 (self->priv->_path));
	_tmp2_ = thunar_vfs_mime_handler_exec ((ThunarVfsMimeHandler*) mime_app, gdk_screen_get_default (), paths, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_thunar_vfs_info_unref0 (info);
		__g_list_free_thunar_vfs_path_unref0 (paths);
		return FALSE;
	}
	result = _tmp2_;
	_thunar_vfs_info_unref0 (info);
	__g_list_free_thunar_vfs_path_unref0 (paths);
	return result;
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static GSList* desktop_agnostic_vfs_file_thunar_vfs_real_enumerate_children (DesktopAgnosticVFSFile* base, GError** error) {
	DesktopAgnosticVFSFileThunarVFS * self;
	GSList* result;
	GError * _inner_error_;
	GSList* children;
	GDir* dir;
	const char* child;
	GSList* _tmp2_;
	char* _tmp3_;
	GDir* _tmp4_;
	GDir* _tmp5_;
	GDir* _tmp6_;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	_inner_error_ = NULL;
	children = NULL;
	dir = NULL;
	child = NULL;
	if (desktop_agnostic_vfs_file_get_file_type ((DesktopAgnosticVFSFile*) self) != DESKTOP_AGNOSTIC_VFS_FILE_TYPE_DIRECTORY) {
		char* _tmp0_;
		GError* _tmp1_;
		_inner_error_ = (_tmp1_ = g_error_new (DESKTOP_AGNOSTIC_VFS_FILE_ERROR, DESKTOP_AGNOSTIC_VFS_FILE_ERROR_INVALID_TYPE, "File '%s' is not a directory.", _tmp0_ = desktop_agnostic_vfs_file_get_impl_path ((DesktopAgnosticVFSFile*) self)), _g_free0 (_tmp0_), _tmp1_);
		{
			g_propagate_error (error, _inner_error_);
			__g_slist_free_g_object_unref0 (children);
			_g_dir_close0 (dir);
			return NULL;
		}
	}
	children = (_tmp2_ = NULL, __g_slist_free_g_object_unref0 (children), _tmp2_);
	_tmp5_ = (_tmp4_ = g_dir_open (_tmp3_ = desktop_agnostic_vfs_file_get_impl_path ((DesktopAgnosticVFSFile*) self), 0, &_inner_error_), _g_free0 (_tmp3_), _tmp4_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_slist_free_g_object_unref0 (children);
		_g_dir_close0 (dir);
		return NULL;
	}
	dir = (_tmp6_ = _tmp5_, _g_dir_close0 (dir), _tmp6_);
	while (TRUE) {
		char* child_path;
		char* _tmp8_;
		char* _tmp7_;
		DesktopAgnosticVFSFile* _tmp9_;
		if (!((child = g_dir_read_name (dir)) != NULL)) {
			break;
		}
		child_path = NULL;
		child_path = (_tmp8_ = g_build_filename (_tmp7_ = desktop_agnostic_vfs_file_get_impl_path ((DesktopAgnosticVFSFile*) self), child, NULL), _g_free0 (child_path), _tmp8_);
		_g_free0 (_tmp7_);
		_tmp9_ = desktop_agnostic_vfs_file_new_for_path (child_path, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (child_path);
			__g_slist_free_g_object_unref0 (children);
			_g_dir_close0 (dir);
			return NULL;
		}
		children = g_slist_append (children, _tmp9_);
		_g_free0 (child_path);
	}
	result = children;
	_g_dir_close0 (dir);
	return result;
}


static gboolean desktop_agnostic_vfs_file_thunar_vfs_real_copy (DesktopAgnosticVFSFile* base, DesktopAgnosticVFSFile* destination, gboolean overwrite, GError** error) {
	DesktopAgnosticVFSFileThunarVFS * self;
	gboolean result;
	GError * _inner_error_;
	char* data;
	gsize length = 0UL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	char* _tmp6_;
	gboolean _tmp5_;
	char* _tmp4_ = NULL;
	gboolean _tmp7_;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	g_return_val_if_fail (destination != NULL, FALSE);
	_inner_error_ = NULL;
	data = NULL;
	if (!overwrite) {
		_tmp0_ = desktop_agnostic_vfs_file_exists (destination);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp1_;
		GError* _tmp2_;
		_inner_error_ = (_tmp2_ = g_error_new (DESKTOP_AGNOSTIC_VFS_FILE_ERROR, DESKTOP_AGNOSTIC_VFS_FILE_ERROR_EXISTS, "The destination file (%s) exists.", _tmp1_ = desktop_agnostic_vfs_file_get_impl_path ((DesktopAgnosticVFSFile*) self)), _g_free0 (_tmp1_), _tmp2_);
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (data);
			return FALSE;
		}
	}
	_tmp7_ = (_tmp5_ = desktop_agnostic_vfs_file_load_contents ((DesktopAgnosticVFSFile*) self, &_tmp4_, &length, &_inner_error_), data = (_tmp6_ = _tmp4_, _g_free0 (data), _tmp6_), _tmp5_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (data);
		return FALSE;
	}
	if (_tmp7_) {
		gboolean _tmp8_;
		_tmp8_ = desktop_agnostic_vfs_file_replace_contents (destination, data, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (data);
			return FALSE;
		}
		_tmp3_ = _tmp8_;
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	_g_free0 (data);
	return result;
}


static gboolean desktop_agnostic_vfs_file_thunar_vfs_real_remove (DesktopAgnosticVFSFile* base, GError** error) {
	DesktopAgnosticVFSFileThunarVFS * self;
	gboolean result;
	GError * _inner_error_;
	char* _tmp2_;
	gboolean _tmp3_;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	_inner_error_ = NULL;
	if (!desktop_agnostic_vfs_file_exists ((DesktopAgnosticVFSFile*) self)) {
		char* _tmp0_;
		GError* _tmp1_;
		_inner_error_ = (_tmp1_ = g_error_new (DESKTOP_AGNOSTIC_VFS_FILE_ERROR, DESKTOP_AGNOSTIC_VFS_FILE_ERROR_FILE_NOT_FOUND, "The file '%s' does not exist.", _tmp0_ = desktop_agnostic_vfs_file_get_uri ((DesktopAgnosticVFSFile*) self)), _g_free0 (_tmp0_), _tmp1_);
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	result = (_tmp3_ = g_unlink (_tmp2_ = desktop_agnostic_vfs_file_get_impl_path ((DesktopAgnosticVFSFile*) self)) == 0, _g_free0 (_tmp2_), _tmp3_);
	return result;
}


DesktopAgnosticVFSFileThunarVFS* desktop_agnostic_vfs_file_thunar_vfs_construct (GType object_type) {
	DesktopAgnosticVFSFileThunarVFS * self;
	self = (DesktopAgnosticVFSFileThunarVFS*) desktop_agnostic_vfs_file_construct (object_type);
	return self;
}


DesktopAgnosticVFSFileThunarVFS* desktop_agnostic_vfs_file_thunar_vfs_new (void) {
	return desktop_agnostic_vfs_file_thunar_vfs_construct (DESKTOP_AGNOSTIC_VFS_TYPE_FILE_THUNAR_VFS);
}


static void* desktop_agnostic_vfs_file_thunar_vfs_real_get_implementation (DesktopAgnosticVFSFile* base) {
	void* result;
	DesktopAgnosticVFSFileThunarVFS* self;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	result = (void*) self->priv->_path;
	return result;
}


static char* desktop_agnostic_vfs_file_thunar_vfs_real_get_impl_path (DesktopAgnosticVFSFile* base) {
	char* result;
	DesktopAgnosticVFSFileThunarVFS* self;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	result = g_strdup (thunar_vfs_path_dup_string (self->priv->_path));
	return result;
}


static char* desktop_agnostic_vfs_file_thunar_vfs_real_get_impl_uri (DesktopAgnosticVFSFile* base) {
	char* result;
	DesktopAgnosticVFSFileThunarVFS* self;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	result = g_strdup (self->priv->_uri);
	return result;
}


static DesktopAgnosticVFSFileType desktop_agnostic_vfs_file_thunar_vfs_real_get_file_type (DesktopAgnosticVFSFile* base) {
	DesktopAgnosticVFSFileType result;
	DesktopAgnosticVFSFileThunarVFS* self;
	DesktopAgnosticVFSFileType ft;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_UNKNOWN;
	;
	if (self->priv->_info != NULL) {
		if ((self->priv->_info->flags & THUNAR_VFS_FILE_FLAGS_SYMLINK) != 0) {
			ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_SYMBOLIC_LINK;
		} else {
			switch (self->priv->_info->type) {
				case THUNAR_VFS_FILE_TYPE_REGULAR:
				{
					ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_REGULAR;
					break;
				}
				case THUNAR_VFS_FILE_TYPE_DIRECTORY:
				{
					ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_DIRECTORY;
					break;
				}
				case THUNAR_VFS_FILE_TYPE_SYMLINK:
				{
					ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_SYMBOLIC_LINK;
					break;
				}
				case THUNAR_VFS_FILE_TYPE_PORT:
				case THUNAR_VFS_FILE_TYPE_DOOR:
				case THUNAR_VFS_FILE_TYPE_SOCKET:
				case THUNAR_VFS_FILE_TYPE_BLOCKDEV:
				case THUNAR_VFS_FILE_TYPE_CHARDEV:
				case THUNAR_VFS_FILE_TYPE_FIFO:
				{
					ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_SPECIAL;
					break;
				}
				case THUNAR_VFS_FILE_TYPE_UNKNOWN:
				{
					ft = DESKTOP_AGNOSTIC_VFS_FILE_TYPE_UNKNOWN;
					break;
				}
			}
		}
	}
	result = ft;
	return result;
}


static DesktopAgnosticVFSAccessFlags desktop_agnostic_vfs_file_thunar_vfs_real_get_access_flags (DesktopAgnosticVFSFile* base) {
	DesktopAgnosticVFSAccessFlags result;
	DesktopAgnosticVFSFileThunarVFS* self;
	DesktopAgnosticVFSAccessFlags flags;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	flags = DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_NONE;
	if (self->priv->_info != NULL) {
		if ((self->priv->_info->flags & THUNAR_VFS_FILE_FLAGS_READABLE) != 0) {
			flags = flags | DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_READ;
		}
		if ((self->priv->_info->flags & THUNAR_VFS_FILE_FLAGS_WRITABLE) != 0) {
			flags = flags | DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_WRITE;
		}
		if ((self->priv->_info->flags & THUNAR_VFS_FILE_FLAGS_EXECUTABLE) != 0) {
			flags = flags | DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_EXECUTE;
		}
	}
	result = flags;
	return result;
}


static DesktopAgnosticVFSFile* desktop_agnostic_vfs_file_thunar_vfs_real_get_parent (DesktopAgnosticVFSFile* base) {
	DesktopAgnosticVFSFile* result;
	DesktopAgnosticVFSFileThunarVFS* self;
	ThunarVfsPath* path;
	self = (DesktopAgnosticVFSFileThunarVFS*) base;
	path = NULL;
	path = thunar_vfs_path_get_parent (self->priv->_path);
	if (path == NULL) {
		result = NULL;
		return result;
	} else {
		DesktopAgnosticVFSFile* _result_;
		DesktopAgnosticVFSFile* _tmp0_;
		_result_ = NULL;
		_result_ = (_tmp0_ = (DesktopAgnosticVFSFile*) desktop_agnostic_vfs_file_thunar_vfs_new (), _g_object_unref0 (_result_), _tmp0_);
		desktop_agnostic_vfs_file_init (_result_, thunar_vfs_path_dup_uri (path));
		result = _result_;
		return result;
	}
}


static void desktop_agnostic_vfs_file_thunar_vfs_class_init (DesktopAgnosticVFSFileThunarVFSClass * klass) {
	desktop_agnostic_vfs_file_thunar_vfs_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSFileThunarVFSPrivate));
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->init = desktop_agnostic_vfs_file_thunar_vfs_real_init;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->exists = desktop_agnostic_vfs_file_thunar_vfs_real_exists;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->monitor = desktop_agnostic_vfs_file_thunar_vfs_real_monitor;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->load_contents = desktop_agnostic_vfs_file_thunar_vfs_real_load_contents;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->replace_contents = desktop_agnostic_vfs_file_thunar_vfs_real_replace_contents;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->launch = desktop_agnostic_vfs_file_thunar_vfs_real_launch;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->enumerate_children = desktop_agnostic_vfs_file_thunar_vfs_real_enumerate_children;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->copy = desktop_agnostic_vfs_file_thunar_vfs_real_copy;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->remove = desktop_agnostic_vfs_file_thunar_vfs_real_remove;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_implementation = desktop_agnostic_vfs_file_thunar_vfs_real_get_implementation;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_impl_path = desktop_agnostic_vfs_file_thunar_vfs_real_get_impl_path;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_impl_uri = desktop_agnostic_vfs_file_thunar_vfs_real_get_impl_uri;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_file_type = desktop_agnostic_vfs_file_thunar_vfs_real_get_file_type;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_access_flags = desktop_agnostic_vfs_file_thunar_vfs_real_get_access_flags;
	DESKTOP_AGNOSTIC_VFS_FILE_CLASS (klass)->get_parent = desktop_agnostic_vfs_file_thunar_vfs_real_get_parent;
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_file_thunar_vfs_get_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_file_thunar_vfs_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_IMPLEMENTATION, "implementation");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_IMPL_PATH, "impl-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_IMPL_URI, "impl-uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_FILE_TYPE, "file-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_PARENT, "parent");
}


static void desktop_agnostic_vfs_file_thunar_vfs_instance_init (DesktopAgnosticVFSFileThunarVFS * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_file_thunar_vfs_finalize (GObject* obj) {
	DesktopAgnosticVFSFileThunarVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS (obj);
	_thunar_vfs_path_unref0 (self->priv->_path);
	_thunar_vfs_info_unref0 (self->priv->_info);
	_g_free0 (self->priv->_uri);
	G_OBJECT_CLASS (desktop_agnostic_vfs_file_thunar_vfs_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_file_thunar_vfs_get_type (void) {
	static GType desktop_agnostic_vfs_file_thunar_vfs_type_id = 0;
	if (desktop_agnostic_vfs_file_thunar_vfs_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSFileThunarVFSClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_file_thunar_vfs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSFileThunarVFS), 0, (GInstanceInitFunc) desktop_agnostic_vfs_file_thunar_vfs_instance_init, NULL };
		desktop_agnostic_vfs_file_thunar_vfs_type_id = g_type_register_static (DESKTOP_AGNOSTIC_VFS_TYPE_FILE, "DesktopAgnosticVFSFileThunarVFS", &g_define_type_info, 0);
	}
	return desktop_agnostic_vfs_file_thunar_vfs_type_id;
}


static void desktop_agnostic_vfs_file_thunar_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSFileThunarVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_IMPLEMENTATION:
		g_value_set_pointer (value, desktop_agnostic_vfs_file_get_implementation ((DesktopAgnosticVFSFile*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_IMPL_PATH:
		g_value_set_string (value, desktop_agnostic_vfs_file_get_impl_path ((DesktopAgnosticVFSFile*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_IMPL_URI:
		g_value_set_string (value, desktop_agnostic_vfs_file_get_impl_uri ((DesktopAgnosticVFSFile*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_FILE_TYPE:
		g_value_set_enum (value, desktop_agnostic_vfs_file_get_file_type ((DesktopAgnosticVFSFile*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_FILE_THUNAR_VFS_PARENT:
		g_value_set_object (value, desktop_agnostic_vfs_file_get_parent ((DesktopAgnosticVFSFile*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




