/* test-vfs-file.c generated by valac, the Vala compiler
 * generated from test-vfs-file.vala, do not modify */

/*
 * Desktop Agnostic Library: Test for the file (monitor) implementations.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <libdesktop-agnostic/vfs.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



#define CONTENT "Desktop Agnostic Library"
static void _g_slist_free_g_object_unref (GSList* self);
gint _main (char** args, int args_length1);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


gint _main (char** args, int args_length1) {
	gint result;
	GError * _inner_error_;
	_inner_error_ = NULL;
	gdk_init (&args_length1, &args);
	{
		gboolean test_launch = FALSE;
		const char* path;
		DesktopAgnosticVFSFile* tmp;
		char* file_path;
		DesktopAgnosticVFSFile* file;
		char* contents;
		gsize length = 0UL;
		char* file_copy_path;
		DesktopAgnosticVFSFile* file_copy;
		char* copy_contents;
		gsize copy_length = 0UL;
		gboolean _tmp0_ = FALSE;
		DesktopAgnosticVFSFile* _tmp1_;
		DesktopAgnosticVFSFile* _tmp2_;
		DesktopAgnosticVFSFile* _tmp3_;
		char* _tmp4_;
		char* _tmp5_;
		GSList* _tmp6_;
		GSList* _tmp7_;
		char* _tmp8_;
		DesktopAgnosticVFSFile* _tmp9_;
		DesktopAgnosticVFSFile* _tmp10_;
		char* _tmp14_;
		char* _tmp13_;
		DesktopAgnosticVFSFile* _tmp12_;
		DesktopAgnosticVFSFile* _tmp11_;
		DesktopAgnosticVFSFile* _tmp15_;
		char* _tmp18_;
		gboolean _tmp17_;
		char* _tmp16_ = NULL;
		char* _tmp20_;
		DesktopAgnosticVFSFile* _tmp21_;
		DesktopAgnosticVFSFile* _tmp22_;
		gboolean _tmp23_;
		char* _tmp26_;
		gboolean _tmp25_;
		char* _tmp24_ = NULL;
		DesktopAgnosticVFSFile* _tmp29_;
		path = NULL;
		tmp = NULL;
		file_path = NULL;
		file = NULL;
		contents = NULL;
		file_copy_path = NULL;
		file_copy = NULL;
		copy_contents = NULL;
		if (args_length1 > 1) {
			_tmp0_ = _vala_strcmp0 (args[1], "launch") == 0;
		} else {
			_tmp0_ = FALSE;
		}
		test_launch = _tmp0_;
		desktop_agnostic_vfs_init (&_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (tmp);
			_g_free0 (file_path);
			_g_object_unref0 (file);
			_g_free0 (contents);
			_g_free0 (file_copy_path);
			_g_object_unref0 (file_copy);
			_g_free0 (copy_contents);
			goto __catch0_g_error;
		}
		path = g_get_tmp_dir ();
		_tmp1_ = desktop_agnostic_vfs_file_new_for_path (path, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (tmp);
			_g_free0 (file_path);
			_g_object_unref0 (file);
			_g_free0 (contents);
			_g_free0 (file_copy_path);
			_g_object_unref0 (file_copy);
			_g_free0 (copy_contents);
			goto __catch0_g_error;
		}
		tmp = (_tmp2_ = _tmp1_, _g_object_unref0 (tmp), _tmp2_);
		g_assert ((_tmp3_ = desktop_agnostic_vfs_file_get_parent (tmp)) != NULL);
		_g_object_unref0 (_tmp3_);
		g_assert (desktop_agnostic_vfs_file_exists (tmp));
		g_assert (desktop_agnostic_vfs_file_get_file_type (tmp) == DESKTOP_AGNOSTIC_VFS_FILE_TYPE_DIRECTORY);
		g_assert ((desktop_agnostic_vfs_file_get_access_flags (tmp) & DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_READ) != 0);
		g_assert (desktop_agnostic_vfs_file_is_readable (tmp));
		g_assert ((desktop_agnostic_vfs_file_get_access_flags (tmp) & DESKTOP_AGNOSTIC_VFS_ACCESS_FLAGS_WRITE) != 0);
		g_assert (desktop_agnostic_vfs_file_is_writable (tmp));
		g_message ("test-vfs-file.vala:56: URI: %s", _tmp4_ = desktop_agnostic_vfs_file_get_uri (tmp));
		_g_free0 (_tmp4_);
		g_message ("test-vfs-file.vala:57: Path: %s", _tmp5_ = desktop_agnostic_vfs_file_get_path (tmp));
		_g_free0 (_tmp5_);
		_tmp6_ = desktop_agnostic_vfs_file_enumerate_children (tmp, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (tmp);
			_g_free0 (file_path);
			_g_object_unref0 (file);
			_g_free0 (contents);
			_g_free0 (file_copy_path);
			_g_object_unref0 (file_copy);
			_g_free0 (copy_contents);
			goto __catch0_g_error;
		}
		g_message ("test-vfs-file.vala:58: # of files: %u", g_slist_length (_tmp7_ = _tmp6_));
		__g_slist_free_g_object_unref0 (_tmp7_);
		file_path = (_tmp8_ = g_build_filename (path, "desktop-agnostic-test", NULL), _g_free0 (file_path), _tmp8_);
		_tmp9_ = desktop_agnostic_vfs_file_new_for_path (file_path, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (tmp);
			_g_free0 (file_path);
			_g_object_unref0 (file);
			_g_free0 (contents);
			_g_free0 (file_copy_path);
			_g_object_unref0 (file_copy);
			_g_free0 (copy_contents);
			goto __catch0_g_error;
		}
		file = (_tmp10_ = _tmp9_, _g_object_unref0 (file), _tmp10_);
		g_assert (((_tmp11_ = desktop_agnostic_vfs_file_get_parent (file)) != NULL) && (_vala_strcmp0 (_tmp13_ = desktop_agnostic_vfs_file_get_uri (_tmp12_ = desktop_agnostic_vfs_file_get_parent (file)), _tmp14_ = desktop_agnostic_vfs_file_get_uri (tmp)) == 0));
		_g_free0 (_tmp14_);
		_g_free0 (_tmp13_);
		_g_object_unref0 (_tmp12_);
		_g_object_unref0 (_tmp11_);
		tmp = (_tmp15_ = NULL, _g_object_unref0 (tmp), _tmp15_);
		desktop_agnostic_vfs_file_replace_contents (file, CONTENT, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (tmp);
			_g_free0 (file_path);
			_g_object_unref0 (file);
			_g_free0 (contents);
			_g_free0 (file_copy_path);
			_g_object_unref0 (file_copy);
			_g_free0 (copy_contents);
			goto __catch0_g_error;
		}
		_tmp17_ = desktop_agnostic_vfs_file_load_contents (file, &_tmp16_, &length, &_inner_error_);
		contents = (_tmp18_ = _tmp16_, _g_free0 (contents), _tmp18_);
		_tmp17_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (tmp);
			_g_free0 (file_path);
			_g_object_unref0 (file);
			_g_free0 (contents);
			_g_free0 (file_copy_path);
			_g_object_unref0 (file_copy);
			_g_free0 (copy_contents);
			goto __catch0_g_error;
		}
		g_assert (_vala_strcmp0 (contents, CONTENT) == 0);
		if (test_launch) {
			gboolean _tmp19_;
			_tmp19_ = desktop_agnostic_vfs_file_launch (file, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (tmp);
				_g_free0 (file_path);
				_g_object_unref0 (file);
				_g_free0 (contents);
				_g_free0 (file_copy_path);
				_g_object_unref0 (file_copy);
				_g_free0 (copy_contents);
				goto __catch0_g_error;
			}
			g_assert (_tmp19_);
		}
		file_copy_path = (_tmp20_ = g_strdup_printf ("%s-copy", file_path), _g_free0 (file_copy_path), _tmp20_);
		_tmp21_ = desktop_agnostic_vfs_file_new_for_path (file_copy_path, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (tmp);
			_g_free0 (file_path);
			_g_object_unref0 (file);
			_g_free0 (contents);
			_g_free0 (file_copy_path);
			_g_object_unref0 (file_copy);
			_g_free0 (copy_contents);
			goto __catch0_g_error;
		}
		file_copy = (_tmp22_ = _tmp21_, _g_object_unref0 (file_copy), _tmp22_);
		_tmp23_ = desktop_agnostic_vfs_file_copy (file, file_copy, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (tmp);
			_g_free0 (file_path);
			_g_object_unref0 (file);
			_g_free0 (contents);
			_g_free0 (file_copy_path);
			_g_object_unref0 (file_copy);
			_g_free0 (copy_contents);
			goto __catch0_g_error;
		}
		g_assert (_tmp23_);
		_tmp25_ = desktop_agnostic_vfs_file_load_contents (file_copy, &_tmp24_, &copy_length, &_inner_error_);
		copy_contents = (_tmp26_ = _tmp24_, _g_free0 (copy_contents), _tmp26_);
		_tmp25_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (tmp);
			_g_free0 (file_path);
			_g_object_unref0 (file);
			_g_free0 (contents);
			_g_free0 (file_copy_path);
			_g_object_unref0 (file_copy);
			_g_free0 (copy_contents);
			goto __catch0_g_error;
		}
		g_assert (_vala_strcmp0 (contents, copy_contents) == 0);
		g_assert (length == copy_length);
		if (!test_launch) {
			gboolean _tmp27_;
			gboolean _tmp28_;
			_tmp27_ = desktop_agnostic_vfs_file_remove (file_copy, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (tmp);
				_g_free0 (file_path);
				_g_object_unref0 (file);
				_g_free0 (contents);
				_g_free0 (file_copy_path);
				_g_object_unref0 (file_copy);
				_g_free0 (copy_contents);
				goto __catch0_g_error;
			}
			g_assert (_tmp27_);
			g_assert (!desktop_agnostic_vfs_file_exists (file_copy));
			_tmp28_ = desktop_agnostic_vfs_file_remove (file, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (tmp);
				_g_free0 (file_path);
				_g_object_unref0 (file);
				_g_free0 (contents);
				_g_free0 (file_copy_path);
				_g_object_unref0 (file_copy);
				_g_free0 (copy_contents);
				goto __catch0_g_error;
			}
			g_assert (_tmp28_);
			g_assert (!desktop_agnostic_vfs_file_exists (file));
		}
		file = (_tmp29_ = NULL, _g_object_unref0 (file), _tmp29_);
		desktop_agnostic_vfs_shutdown (&_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (tmp);
			_g_free0 (file_path);
			_g_object_unref0 (file);
			_g_free0 (contents);
			_g_free0 (file_copy_path);
			_g_object_unref0 (file_copy);
			_g_free0 (copy_contents);
			goto __catch0_g_error;
		}
		_g_object_unref0 (tmp);
		_g_free0 (file_path);
		_g_object_unref0 (file);
		_g_free0 (contents);
		_g_free0 (file_copy_path);
		_g_object_unref0 (file_copy);
		_g_free0 (copy_contents);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("test-vfs-file.vala:88: Error: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _main (argv, argc);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




