/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#ifdef HAVE_SYS_IPC_H
#  include <sys/ipc.h>
#endif

#ifdef BSD  /* BSD */
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#endif


extern int errno;

/* -------------------------
   Init function for daemons
   ------------------------- */

#ifdef BSD

void proc_daemon_sig_child()
{
  int pid, status;
#if 0
  union wait status;
#endif

  while ((pid = wait3(&status, WNOHANG, (struct rusage *) 0)) > 0) ;
}

#endif  /* BSD */


int proc_daemon_init()
{
  int fd, child_pid;


  /* If started by init (PID 1), do not detach */

  if (getppid() != 1)
  {
    /* --- Ignore terminal stop signals (BSD) --- */

#ifdef SIGTTOU
    signal(SIGTTOU, SIG_IGN);
#endif
#ifdef SIGTTIN
    signal(SIGTTIN, SIG_IGN);
#endif
#ifdef SIGTSTP
    signal(SIGTSTP, SIG_IGN);
#endif
  
  
    /* --- Run in background --- */

    if ((child_pid = fork()) == -1) return(0);  /* err_sys("Cannot fork first child");  */  /* Error */
    else if (child_pid) exit(0);                                        /* Parent */


    /* --- Disassociate from process group and controlling terminal --- */

#ifdef BSD  /* BSD */

#ifdef HAVE_SETPGRP
    if (setpgrp(0, getpid()) == -1) return(0);  /* err_sys("Cannot change process group (BSD-wise)"); */
#endif

    if ((fd = open("/dev/tty", O_RDWR)) >= 0)
    {
      ioctl(fd, TIOCNOTTY, (char *) 0);
      close(fd);
    }

#else  /* System V */

#ifdef HAVE_SETPGRP
    if (setpgrp() == -1) return(0);  /* err_sys("Cannot change process group (SysV-wise)"); */
#endif

    signal(SIGHUP, SIG_IGN);

    if ((child_pid = fork()) == -1) return(0);  /* err_sys("Cannot fork second child.");  */ /* Error */
    else if (child_pid) exit(0);                                         /* Parent */

#endif
  }
  
  /* --- Close all open file descriptors --- */

  for (fd = 0; fd < NOFILE; fd++) close(fd);
  errno = 0;  /* Rectify close() effect */

  
  /* --- Change current working directory --- */

  chdir("/");


  /* --- Reset file access creation mask --- */

  umask(0);


  /* --- Avoid generating zombie offspring --- */

#ifdef BSD  /* BSD */
  signal(SIGCHLD, proc_daemon_sig_child);
#else  /* System V */
  signal(SIGCHLD, SIG_IGN);  /* CHLD is usually an alias for CLD anyway */
#endif

  return(1);
}
