/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Zaliva, Vadim Kurland

  Author:  Vadim Zaliva lord@crocodile.org

  $Id: FWObjectDatabase.hh,v 1.4 2001/12/24 01:01:29 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __FWOBJECTDATABASE_HH_FLAG__
#define __FWOBJECTDATABASE_HH_FLAG__

#include <fwbuilder/FWObject.hh>
#include <fwbuilder/FWException.hh>
#include <fwbuilder/ThreadTools.hh>
#include <fwbuilder/XMLTools.hh>

namespace libfwbuilder
{

/**
 * Database of objects.
 */
class FWObjectDatabase : public FWObject
{
    protected:

    static long               IDcounter     ;
//    static Mutex              IDmutex       ;
    static const std::string       DTD_FILE_NAME ;

    std::string data_file;

    public:

    DECLARE_FWOBJECT_SUBTYPE(FWObjectDatabase);
    
    FWObjectDatabase();
    virtual ~FWObjectDatabase() {};
    
    // --- XML import/export ---
    
    /**
     * This is the main "Create" method:
     * it creates instance of FWObject of given type
     */
    virtual FWObject *create(const std::string &type);

    /**
     * Creates instance of FWObject using its XML representation
     */
    virtual FWObject *createFromXML(xmlNodePtr data);

    virtual xmlNodePtr toXML(xmlNodePtr parent);
    
    std::string generateUniqueId();
    
    // --- Load/Save ---
    
    virtual void saveFile       ( const std::string &filename) throw(FWException); 
    virtual void saveXML        ( xmlDocPtr             ) throw(FWException); 
    virtual void load           ( const std::string &filename, XMLTools::UpgradePredicate *upgrade) throw(FWException);

    void setFileName (const std::string &filename);
    const std::string& getFileName ();
    const std::string  getFileDir ();

    // --- Standard objects ---

    struct StandardObjects
    {
	std::string     rootId;

        std::string     AnyNetworkId;
        std::string     AnyIPServiceId;
        std::string     AnyIntervalId;
        
        std::string     ObjectsId;
        std::string     HostsId;      
        std::string     NetworksId;    
        std::string     ObjectGroupsId;
        
        std::string     ServicesId;
        std::string     IPServicesId;
        std::string     ICMPServicesId;
        std::string     UDPServicesId;
        std::string     TCPServicesId;
        std::string     ServiceGroupsId;
        std::string     CustomServicesId;

        std::string     TimeId;
        
        std::string     FirewallsId;
    };

    struct StandardObjects std;

    // singelton

    static FWObjectDatabase  *db;

};

}

#endif

