/*
******************************************************************************

   Demo of the GCP extension.

   Authors:	2000 Christoph Egger	[Christoph_Egger@t-online.de]
  
   This code is placed in the public domain and may be used freely for any
   purpose.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>

#include <ggi/ggi.h>
#include <ggi/gcp.h>


void do_demo(ggi_visual_t vis)
{

	gcp_RGBAcolor rgba;
	gcp_YUVcolor yuv;
	gcp_CMYKcolor cmyk;
	gcp_HSVcolor hsv;
	gcp_YCCcolor ycc;

	gcp_pixel pixel;


	gcpSetColorfulPalette(vis);


	rgba.r = 0xFFFF;
	rgba.g = 0xFFFF;
	rgba.b = 0xFFFF;
	rgba.a = 0xFFFF;

	printf("rgba (%X,%X,%X,%X)\n",
		rgba.r, rgba.g, rgba.b, rgba.a);

	pixel = gcpMapRGBAColor(vis, &rgba);

	printf("pixel-value: %i\n", pixel);


	printf("\nConvert to another color-spaces:\n\n");

	gcpUnmapRGBAPixel(vis, pixel, &rgba);
	printf("rgba (%X,%X,%X,%X)\n",
		rgba.r, rgba.g, rgba.b, rgba.a);

	gcpUnmapYUVPixel(vis, pixel, &yuv);
	printf("yuv (%.03f,%.03f,%.03f)\n",
		yuv.y, yuv.u, yuv.v);

	gcpUnmapCMYKPixel(vis, pixel, &cmyk);
	printf("cmyk (%X,%X,%X,%X)\n",
		cmyk.c,cmyk.m,cmyk.y,cmyk.k);

	gcpUnmapHSVPixel(vis, pixel, &hsv);
	printf("hsv (%.03f,%.03f,%.03f)\n",
		hsv.h,hsv.s,hsv.v);

	gcpUnmapYCCPixel(vis, pixel, &ycc);
	printf("ycc (%X,%X,%X)\n",
		ycc.y,ycc.c1,ycc.c2);


	printf("\nConvert back to the origin color-space:\n\n");

	printf("pixel-value (converted from RGBA): %i\n", gcpMapRGBAColor(vis, &rgba));
	printf("pixel-value (converted from YUV): %i\n", gcpMapYUVColor(vis, &yuv));
	printf("pixel-value (converted from CMYK): %i\n", gcpMapCMYKColor(vis, &cmyk));
	printf("pixel-value (converted from HSV): %i\n", gcpMapHSVColor(vis, &hsv));
	printf("pixel-value (converted from YCC): %i\n", gcpMapYCCColor(vis, &ycc));


}	/* do_demo */



int main(void)
{
	ggi_visual_t vis;

	/* Initialize LibGGI */
	if (ggiInit() != 0) {
		fprintf(stderr, "Unable to initialize LibGGI\n");
		exit(1);
	}
	
	/* Initialize LibGCP extension */
	if (gcpInit() != 0) {
		ggiPanic("Unable to initialize LibGCP extension\n");
	}

	/* Open the default visual */
	if ((vis = ggiOpen(NULL)) == NULL) {
		ggiPanic("Unable to open default visual\n");
	}
	
	/* Turn on asynchronous mode (which should always be used) */
	ggiSetFlags(vis, GGIFLAG_ASYNC);
	
	/* Set the default mode */
	if (ggiSetSimpleMode(vis, GGI_AUTO, GGI_AUTO, GGI_AUTO, GT_AUTO) < 0) {
		ggiPanic("Unable to set default mode\n");
	}
	
	/* Attach the GCP extension to the visual */
	if (gcpAttach(vis) < 0) {
		ggiPanic("Unable to attach EDEMO extension to visual\n");
	}


	do_demo(vis);

	
	/* Detach extension from visual */
	gcpDetach(vis);

	/* Close visual */
	ggiClose(vis);

	/* Deinitialize LibGCP extension */
	gcpExit();

	/* Deinitialize LibGGI */
	ggiExit();

	return 0;
}
