/*
*****************************************************************************

   LIBGCP: extension internals

   Copyright (C) 2000-2001 Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


*****************************************************************************
*/


#ifndef _GGI_CONVERT_INT_H
#define _GGI_CONVERT_INT_H


#include <ggi/internal/gcp.h>



__BEGIN_DECLS


/*  Converts from RGBA colorspace to YUV values.
 */
int gcpRGBA2YUV(ggi_visual_t vis,
		const gcp_RGBAcolor *rgba, gcp_YUVcolor *yuv);


/*  Converts from YUV colorspace to RGBA values.
 */
int gcpYUV2RGBA(ggi_visual_t vis,
		const gcp_YUVcolor *yuv, gcp_RGBAcolor *rgba);




/*  Converts from RGBA colorspace to CMYK values.
 */
int gcpRGBA2CMYK(ggi_visual_t vis,
		const gcp_RGBAcolor *rgba, gcp_CMYKcolor *cmyk);


/*  Converts from CMYK colorspace to RGBA values.
 */
int gcpCMYK2RGBA(ggi_visual_t vis,
		const gcp_CMYKcolor *cmyk, gcp_RGBAcolor *rgba);




/*  Converts from HSV colorspace to RGBA values.
 */
int gcpHSV2RGBA(ggi_visual_t vis,
		const gcp_HSVcolor *hsv, gcp_RGBAcolor *rgba);


/*  Converts an RGBA value into the HSV colorspace.
 */
int gcpRGBA2HSV(ggi_visual_t vis,
		const gcp_RGBAcolor *rgba, gcp_HSVcolor *hsv);




/*  Converts from YCC (Kodak PhotoCD) colorspace to RGBA values.
 */
int gcpYCC2RGBA(ggi_visual_t vis,
		const gcp_YCCcolor *ycc, gcp_RGBAcolor *rgba);


/*  Converts an RGBA value into the YCC (Kodak PhotoCD) colorspace.
 */
int gcpRGBA2YCC(ggi_visual_t vis,
		const gcp_RGBAcolor *rgba, gcp_YCCcolor *ycc);



__END_DECLS



#endif /* _GGI_CONVERT_INT_H */
