/*
 * @(#)ArrayClassLoader.java    1.0.0 11/17/2000 - 12:01:17
 *
 * Copyright (C) 2000,2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.classes.v1.jdk0;

import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;



/**
 * Load classes by byte Arrays.  JDK 1.0+ compatible.
 *
 * @author  Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version $Date: 2003/02/10 22:52:36 $
 * @since   November 17, 2000 (GroboUtils Alpha 0.9.0)
 */
public class ArrayClassLoader extends ClassLoader
{
    //----------------------------
    // Public data
    


    //----------------------------
    // Private data
    
    /**
     * list of all classes
     */
    private Hashtable m_classList = new Hashtable();
    private Hashtable m_classCache = new Hashtable();
    
    
    /**
     * The original bytecode source, for linking.
     */
    private BytecodeSource m_bytecodeSource = null;
    
    //----------------------------
    // constructors
    
    /**
    * Default constructor
    */
    public ArrayClassLoader()
    {
        // do nothing
    }
    
    
    //----------------------------
    // Public methods
    
    
    /**
     * Sets the reference to the original bytecode loader.  By default,
     * the value is <tt>null</tt>.  If the value is <tt>null</tt>, then
     * there is the possibility for a link error.
     */
    public void setBytecodeSource( BytecodeSource bs )
    {
        this.m_bytecodeSource = bs;
    }
    
    
    /**
     * Add a new class to the internal list.
     */
    public void addClass( String name, byte[] bytecode )
    {
        if (name == null || bytecode == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        this.m_classList.put( name, bytecode );
    }
    

    // inherited from ClassLoader
    /**
     * @exception ClassNotFoundException thrown if the given class name
     *      could not be found, or if there was a problem loading the
     *      bytecode for the class.
     */
    public Class loadClass( String name, boolean resolve )
            throws ClassNotFoundException
    {
        Class c;
        
        if (name == null)
        {
            throw new IllegalArgumentException("classname is null");
        }
        
        c = (Class)this.m_classCache.get( name );
        if (c == null)
        {
            try
            {
                c = findSystemClass( name );
            }
            catch (Exception ex)
            {
                byte bytecode[] = getBytecode( name );
                if (bytecode == null)
                {
System.out.println(this.getClass().getName()+"::loadClass( '"+name+
"' ): bytecode for class was never defined.");
                    throw new ClassNotFoundException( name );
                }
                else
                {
                    try
                    {
                        c = defineClass( name, bytecode, 0, bytecode.length );
                        this.m_classCache.put( name, c );
                    }
                    catch (Exception ex2)
                    {
                        // something wrong with the class format
                        throw new ClassNotFoundException(
                            "Bad class format for class "+name );
                    }
                }
            }
        }
        if (resolve)
        {
            resolveClass( c );
        }
        return c;
    }
    
    //----------------------------
    // Protected methods
    
    
    /**
     * Retrieves the internal bytecode for the given class.  If not known,
     * then will attempt to pass it to the bytecode source.
     *
     * @param className a non-null class name.
     */
    protected byte[] getBytecode( String className )
    {
        byte bytecode[] = (byte[])this.m_classList.get( className );
        if (bytecode == null)
        {
            if (this.m_bytecodeSource != null)
            {
                bytecode = this.m_bytecodeSource.getBytecode( className );
                if (bytecode != null)
                {
                    addClass( className, bytecode );
                }
            }
        }
        return bytecode;
    }
    
    
    //----------------------------
    // Private methods
}

