=begin
= Eigensystems

== Modules and classes

* GSL
  * Eigen
    * EigenValues < Vector
    * EigenVectors < Matrix
    * Symm (Module)
      * Workspace (Class)
    * Symmv (Module)
      * Workspace (Class)
    * Herm (Module)
      * Workspace (Class)
    * Hermv (Module)
      * Workspace (Class)
      * Vectors < Matrix::Complex

== Real Symmetric Matrices, GSL::Eigen::Symm module
=== Workspace classes
--- GSL::Eigen::Symm::Workspace::alloc(n)
--- GSL::Eigen::Symmv::Workspace::alloc(n)
--- GSL::Eigen::Herm::Workspace::alloc(n)
--- GSL::Eigen::Hermv::Workspace::alloc(n)

=== Methods to solve eigensystems
--- GSL::Eigen::symm(A)
--- GSL::Eigen::symm(A, workspace)
--- GSL::Matrix#eigen_symm
--- GSL::Matrix#eigen_symm(workspace)
    These methods compute the eigenvalues of the real symmetric matrix. 
    The workspace object ((|workspace|)) can be omitted.

--- GSL::Eigen::symmv(A)
--- GSL::Matrix#eigen_symmv
    These methods compute the eigenvalues and eigenvectors of the real symmetric 
    matrix, and return an array of two elements:
    The first is a (({GSL::Vector})) object which stores all the eigenvalues. 
    The second is a (({GSL::Matrix object})), whose columns contain 
    eigenvectors.

    (1) Singleton method of the (({GSL::Eigen})) module, (({GSL::Eigen::symm}))

          m = GSL::Matrix.alloc([1.0, 1/2.0, 1/3.0, 1/4.0], [1/2.0, 1/3.0, 1/4.0, 1/5.0],
                             [1/3.0, 1/4.0, 1/5.0, 1/6.0], [1/4.0, 1/5.0, 1/6.0, 1/7.0])
          eigval, eigvec = Eigen::symmv(m)

    (2) Instance method of (({GSL::Matrix})) class

          eigval, eigvec = m.eigen_symmv

== Complex Hermitian Matrices
--- GSL::Eigen::herm(A)
--- GSL::Eigen::herm(A, workspace)
--- GSL::Matrix::Complex#eigen_herm
--- GSL::Matrix::Complex#eigen_herm(workspace)
    These methods compute the eigenvalues of the complex hermitian matrix. 

--- GSL::Eigen::hermv(A)
--- GSL::Eigen::hermv(A, workspace)
--- GSL::Matrix::Complex#eigen_hermv
--- GSL::Matrix::Complex#eigen_hermv(workspace

== Sorting Eigenvalues and Eigenvectors
--- GSL::Eigen::symmv_sort(eval, evec, type = GSL::Eigen::SORT_VAL_ASC)
--- GSL::Eigen::Symmv::sort(eval, evec, type = GSL::Eigen::SORT_VAL_ASC)
    These methods simultaneously sort the eigenvalues stored in the vector 
    ((|eval|)) and the corresponding real eigenvectors stored in the 
    columns of the matrix ((|evec|)) into ascending or descending order 
    according to the value of the parameter ((|type|)),
      * (({GSL::Eigen::SORT_VAL_ASC}))
        ascending order in numerical value
      * (({GSL::Eigen::SORT_VAL_DESC}))
        escending order in numerical value
      * (({GSL::Eigen::SORT_ABS_ASC}))
        scending order in magnitude
      * (({GSL::Eigen::SORT_ABS_DESC}))
        descending order in magnitude
    The sorting is carried out ((|in-place|)).

--- GSL::Eigen::hermv_sort(eval, evec, type = GSL::Eigen::SORT_VAL_ASC)
--- GSL::Eigen::Hermv::sort(eval, evec, type = GSL::Eigen::SORT_VAL_ASC)
    These methods simultaneously sort the eigenvalues stored in the vector 
    ((|eval|)) and the corresponding complex eigenvectors stored in the columns 
    of the matrix ((|evec|)) into ascending or descending order according 
    to the value of the parameter ((|type|)) as shown above.

((<prev|URL:linalg.html>))
((<next|URL:fft.html>))

((<Reference index|URL:ref.html>))
((<top|URL:index.html>))

=end
