#include "ctreeview.h"
#include "cform.h"
#include "clayout.h"
#include "cscrollview.h"

//----------------------------------------------------------------------------------------------------------------------------------------
// CMetaClassTreeViewListener
//----------------------------------------------------------------------------------------------------------------------------------------
class CMetaClassTreeViewListener : public CTreeViewListener
{
        // called when a drop occurs
        virtual void OnDragDrop (CObject *inSender, CObject *&ioReceiver, TPoint, Bool &ioDoDrop)
        {
                if (inSender -> ClassIs (__metaclass(CTreeView)) && (ioReceiver -> ClassIs (__metaclass(CForm)) ||
                    ioReceiver -> ClassIs (__metaclass(CLayout))))
                {
                        CComponent *inScrollView = static_cast <CTreeView *> (inSender) -> GetOwner (__metaclass(CScrollView));
                        CComponents inLayout = ioReceiver -> ClassIs (__metaclass(CLayout)) ? CComponents() :
                                                static_cast <CForm *> (ioReceiver) -> GetChildren (__metaclass(CLayout));
                        if (inLayout.GetLength() > 0)
                                inScrollView -> SetOwner (*inLayout[0]);
                        else
                                inScrollView -> SetOwner (static_cast <CComponent *> (ioReceiver));
                        ioDoDrop = false;
                }
        }

        SECTION_DYNAMIC_METACLASS;
};
DECLARE_DYNAMIC_METACLASS ('_mtw', CMetaClassTreeViewListener, CTreeViewListener);
RESOLVE_DYNAMIC_METACLASS (CMetaClassTreeViewListener);

DECLARE_METAMODULE_EXPORT (CMetaClassTreeViewListener);
