/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: CompoundCommand.java,v 1.5 2005/09/18 00:37:17 pietschy Exp $
 */

package org.pietschy.command;

import java.util.ArrayList;

/**
 * An {@link ActionCommand} that executes a number of sub-commands.  Commands are executed
 * in the order they were added.
 * @see #addCommand
 * @see #removeCommand
 */
public class
CompoundCommand
extends ActionCommand
{
   private ArrayList cmdList = new ArrayList();


   public
   CompoundCommand(CommandManager commandManager, String commandId)
   {
      super(commandManager, commandId);
   }

   /**
    * Creates a new command with the specified Id.
    * @param commandId
    */
   public CompoundCommand(String commandId)
   {
      super(commandId);
   }

   /**
    * Creates a new anonymous CompoundCommand. Anonymous commands must be fully programatically
    * created and can't be added a {@link CommandManager}.
    * @see ActionCommand
    */
   public CompoundCommand()
   {
      super();
   }


   /**
    * Executes all the sub commands.  The command are executed in the order of addition.
    */
   public void handleExecute()
   {
      for (int i = 0; i < cmdList.size(); i++)
      {
         ActionCommand command = (ActionCommand) cmdList.get(i);
         command.execute();
      }
   }

   /**
    * Adds an {@link ActionCommand} to the end of the command list.
    * @param cmd the command to installFace.
    */
   public void addCommand(ActionCommand cmd)
   {
      if (cmd != null)
         cmdList.add(cmd);
   }

   /**
    * Removes the {@link ActionCommand} from the the command list.
    * @param cmd the command to remove.
    */
   public void removeCommand(ActionCommand cmd)
   {
      if (cmd != null)
         cmdList.remove(cmd);
   }
}
