/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: FaceIconHelper.java,v 1.3 2004/12/12 05:29:22 pietschy Exp $
 */

package org.pietschy.command;

import javax.swing.*;
import java.beans.PropertyChangeSupport;


/**
 *
 * Copyright (C) 2004, Forge Research Pty. Limited. All rights reserved.
 * www.forge.com.au
 * @version $Revision: 1.3 $
 * @author andrewp
 *
 */
class FaceIconHelper
{
   private PropertyChangeSupport pcs;
   private String iconName;
   private Icon icon;
   private boolean inherited = true;

   public FaceIconHelper(String iconName, PropertyChangeSupport pcs)
   {
      this.iconName = iconName;
      this.pcs = pcs;
   }

   /**
    * Tests if this helpers icon is null.
    * @return <tt>true</tt> if the helpers icon is <tt>null</tt>, <tt>false</tt> otherwise.
    */
   public boolean
   isNull()
   {
      return icon == null;
   }

   public Icon
   getIcon()
   {
      return icon;
   }

   public void
   setIcon(Icon icon)
   {
      if (this.icon != icon)
      {
         Icon old = this.icon;
         this.icon = icon;
         pcs.firePropertyChange(iconName + "Icon", old, icon);
      }
   }

   public boolean
   isInherited()
   {
      return inherited;
   }

   public void
   setInherited(boolean inherited)
   {
      if (this.inherited != inherited)
      {
         boolean old = this.inherited;
         this.inherited = inherited;
         pcs.firePropertyChange(iconName + "IconInherited", old, inherited);
      }
   }
}
