/** Copyright  2003 by Jean-Hugues de Raigniac <jhraigniac@workingfrog.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.workingfrog.i18n.util;

import java.io.File;
import java.io.FilenameFilter;

/**
 * Filter i18n resource bundles.
 *
 * @author Jean-Hugues de Raigniac
 */
public class ResourceBundleFilter implements FilenameFilter {

    /** Singleton */
    private static ResourceBundleFilter instance = null;

    /**
     * Tests if a specified file should be included in a file list.
     *
     * @param   dir   the directory in which the file was found
     * @param   name  the name of the file
     * @return  <code>true</code> if and only if the name should be
     * included in the file list; <code>false</code> otherwise
     */
    public boolean accept(File dir, String name) {
        //TODO instable method : only property files accepted
        return name.indexOf(".properties") > -1;
//        return (dir.canRead()
//                && (name.indexOf("ResourceBundle.") > -1
//                || name.indexOf("ResourceBundle_") > -1));
    }

    /**
     * Returns the singleton.
     *
     * @return  The existing instance or a new one if this is the first call
     */
    public static ResourceBundleFilter getInstance () {
        if (instance == null) {
                instance = new ResourceBundleFilter();
        }

        return instance;
    }
}
