/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  value.cc - AtkValue C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "value.h"
#include "private/value_p.h"
#include "../glib/object.h"
#include "../glib/value.h"

using namespace Inti;

/*  Atk::Value
 */

Atk::Value::~Value()
{
}
	
AtkValueIface* 
Atk::Value::atk_value_iface() const 
{
	return peek<AtkValueIface>(ATK_TYPE_VALUE); 
}
	
Atk::Value::operator AtkValue* () const 
{ 
	return this ? atk_value() : 0; 
}
	
void
Atk::Value::get_current_value(G::Value& value) const
{
	atk_value_get_current_value(atk_value(), value.g_value());
}

void
Atk::Value::get_maximum_value(G::Value& value) const
{
	atk_value_get_maximum_value(atk_value(), value.g_value());
}

void 
Atk::Value::get_minimum_value(G::Value& value) const
{
	atk_value_get_minimum_value(atk_value(), value.g_value());
}

bool
Atk::Value::set_current_value(const G::Value& value)
{
	return atk_value_set_current_value(atk_value(), value.g_value());
}

/*  Atk::ValueIface
 */

void
Atk::ValueIface::init(AtkValueIface *g_iface)
{
	g_iface->get_current_value = &get_current_value_proxy;
	g_iface->get_maximum_value = &get_maximum_value_proxy;
	g_iface->get_minimum_value = &get_minimum_value_proxy;
	g_iface->set_current_value = &set_current_value_proxy;
}

void
Atk::ValueIface::get_current_value_proxy(AtkValue *obj, GValue *value)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(obj));
	Atk::Value *tmp_obj = dynamic_cast<Atk::Value*>(object);
	if (tmp_obj)
		tmp_obj->do_get_current_value(value);
	else
	{
		AtkValueIface *g_iface = static_cast<AtkValueIface*>(g_type_interface_peek_parent(ATK_VALUE_GET_IFACE(obj)));
		if (g_iface->get_current_value)
			g_iface->get_current_value(obj, value);
	}
}

void
Atk::ValueIface::get_maximum_value_proxy(AtkValue *obj, GValue *value)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(obj));
	Atk::Value *tmp_obj = dynamic_cast<Atk::Value*>(object);
	if (tmp_obj)
		tmp_obj->do_get_maximum_value(value);
	else
	{
		AtkValueIface *g_iface = static_cast<AtkValueIface*>(g_type_interface_peek_parent(ATK_VALUE_GET_IFACE(obj)));
		if (g_iface->get_maximum_value)
			g_iface->get_maximum_value(obj, value);
	}
}

void
Atk::ValueIface::get_minimum_value_proxy(AtkValue *obj, GValue *value)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(obj));
	Atk::Value *tmp_obj = dynamic_cast<Atk::Value*>(object);
	if (tmp_obj)
		tmp_obj->do_get_minimum_value(value);
	else
	{
		AtkValueIface *g_iface = static_cast<AtkValueIface*>(g_type_interface_peek_parent(ATK_VALUE_GET_IFACE(obj)));
		if (g_iface->get_minimum_value)
			g_iface->get_minimum_value(obj, value);
	}
}

gboolean
Atk::ValueIface::set_current_value_proxy(AtkValue *obj, const GValue *value)
{
	gboolean result = FALSE;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(obj));
	Atk::Value *tmp_obj = dynamic_cast<Atk::Value*>(object);
	if (tmp_obj)
		result = tmp_obj->do_set_current_value(value);
	else
	{
		AtkValueIface *g_iface = static_cast<AtkValueIface*>(g_type_interface_peek_parent(ATK_VALUE_GET_IFACE(obj)));
		if (g_iface->set_current_value)
			result = g_iface->set_current_value(obj, value);
	}
	return result;
}

/*  Overridable methods
 */

void
Atk::Value::do_get_current_value(GValue *value)
{
	AtkValueIface *g_iface = peek_parent<AtkValueIface>(atk_value_iface());
	if (g_iface->get_current_value)
		g_iface->get_current_value(atk_value(), value);
}

void
Atk::Value::do_get_maximum_value(GValue *value)
{
	AtkValueIface *g_iface = peek_parent<AtkValueIface>(atk_value_iface());
	if (g_iface->get_maximum_value)
		g_iface->get_maximum_value(atk_value(), value);
}

void
Atk::Value::do_get_minimum_value(GValue *value)
{
	AtkValueIface *g_iface = peek_parent<AtkValueIface>(atk_value_iface());
	if (g_iface->get_minimum_value)
		g_iface->get_minimum_value(atk_value(), value);
}

bool
Atk::Value::do_set_current_value(const GValue *value)
{
	bool result = false;
	AtkValueIface *g_iface = peek_parent<AtkValueIface>(atk_value_iface());
	if (g_iface->set_current_value)
		result = g_iface->set_current_value(atk_value(), value);
	return result;
}

