/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  layout.cc - GtkLayout C++ wrapper implmentation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "layout.h"
#include "private/layout_p.h"
#include "../gdk/window.h"

using namespace Inti;

/*  Gtk::Layout
 */

Gtk::Layout::Layout(GtkLayout *layout, bool reference)
: Container((GtkContainer*)layout, reference)
{
}

Gtk::Layout::Layout()
: Container((GtkContainer*)LayoutClass::create())
{
}

Gtk::Layout::Layout(Adjustment *hadjustment, Adjustment *vadjustment)
: Container((GtkContainer*)LayoutClass::create())
{
	if (hadjustment)
		set_hadjustment(hadjustment);
		
	if (vadjustment)
		set_vadjustment(vadjustment);
}

Gtk::Layout::~Layout()
{
}

GtkLayoutClass*
Gtk::Layout::gtk_layout_class() const 
{ 
	return get_class<GtkLayoutClass>(); 
}
	
Gtk::Layout::operator GtkLayout* () const 
{ 
	return this ? gtk_layout() : 0; 
}
	
Gdk::Window* 
Gtk::Layout::bin_window() const
{
	return is_realized() ? G::Object::wrap<Gdk::Window>(gtk_layout()->bin_window) : 0;
}

void
Gtk::Layout::get_size(unsigned int *width, unsigned int *height)
{
	gtk_layout_get_size(gtk_layout(), width, height);
}

Gtk::Adjustment*
Gtk::Layout::get_hadjustment() const
{
	return G::Object::wrap<Adjustment>(gtk_layout_get_hadjustment(gtk_layout()));
}

Gtk::Adjustment*
Gtk::Layout::get_vadjustment() const
{
	return G::Object::wrap<Adjustment>(gtk_layout_get_vadjustment(gtk_layout()));
}

void 
Gtk::Layout::put(Widget& child_widget, int x, int y)
{
	gtk_layout_put(gtk_layout(), child_widget.gtk_widget(), x, y);
}
  
void 
Gtk::Layout::move(Widget& child_widget, int x, int y)
{
	gtk_layout_move(gtk_layout(), child_widget.gtk_widget(), x, y);
}
  
void 
Gtk::Layout::set_size(unsigned int width, unsigned int height)
{
	gtk_layout_set_size(gtk_layout(), width, height);
}

void 
Gtk::Layout::set_hadjustment(Adjustment *adjustment)
{
	gtk_layout_set_hadjustment(gtk_layout(), *adjustment);
}

void 
Gtk::Layout::set_vadjustment(Adjustment *adjustment)
{
	gtk_layout_set_vadjustment(gtk_layout(), *adjustment);
}

/*  Gtk::LayoutClass
 */

void
Gtk::LayoutClass::init(GtkLayoutClass *g_class)
{
	ContainerClass::init((GtkContainerClass*)g_class);
	g_class->set_scroll_adjustments = &set_scroll_adjustments_proxy;
}

GType
Gtk::LayoutClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_LAYOUT, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::LayoutClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::LayoutClass::set_scroll_adjustments_proxy(GtkLayout *layout, GtkAdjustment *hadjustment, GtkAdjustment *vadjustment)
{
	Layout *tmp_layout = G::Object::pointer<Layout>(layout);
	if (tmp_layout)
		tmp_layout->on_set_scroll_adjustments(G::Object::wrap<Gtk::Adjustment>(hadjustment),
		                                      G::Object::wrap<Gtk::Adjustment>(vadjustment));
	else
	{
		GtkLayoutClass *g_class = G::TypeInstance::class_peek_parent<GtkLayoutClass>(GTK_LAYOUT_GET_CLASS(layout));
		if (g_class->set_scroll_adjustments)
			g_class->set_scroll_adjustments(layout, hadjustment, vadjustment);
	}
}

/*  Signal handlers
 */

void
Gtk::Layout::on_set_scroll_adjustments(Adjustment *hadjustment, Adjustment *vadjustment)
{
	GtkLayoutClass *g_class = class_peek_parent<GtkLayoutClass>(gtk_layout_class());
	if (g_class->set_scroll_adjustments)
		g_class->set_scroll_adjustments(gtk_layout(), *hadjustment, *vadjustment);
}

/*  Properties
 */

const Gtk::Layout::HAjustmentPropertyType Gtk::Layout::hadjustment_property("hadjustment");

const Gtk::Layout::VAjustmentPropertyType Gtk::Layout::vadjustment_property("vadjustment");

const Gtk::Layout::WidthPropertyType Gtk::Layout::width_property("width");

const Gtk::Layout::HeightPropertyType Gtk::Layout::height_property("height");

/*  Child properties
 */

const Gtk::Layout::XPropertyType Gtk::Layout::x_property("x");

const Gtk::Layout::YPropertyType Gtk::Layout::y_property("y");

/*  Signals
 */

const Gtk::Layout::SetScrollAdjustmentsSignalType Gtk::Layout::set_scroll_adjustments_signal("set_scroll_adjustments");

