/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  menu.cc - GtkMenu C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "menu.h"
#include "private/menu_p.h"
#include "accelgroup.h"
#include "menuitem.h"
#include "../gdk/screen.h"

using namespace Inti;

/*  Gtk::Menu
 */

Gtk::Menu::Menu(GtkMenu *menu, bool reference)
: MenuShell((GtkMenuShell*)menu, reference)
{
}
	
Gtk::Menu::Menu()
: MenuShell((GtkMenuShell*)MenuClass::create())
{
}

Gtk::Menu::Menu(const AccelGroup& accel_group)
: MenuShell((GtkMenuShell*)MenuClass::create())
{
	set_accel_group(&accel_group);
}

Gtk::Menu::~Menu()
{
}
	
GtkMenuClass* 
Gtk::Menu::gtk_menu_class() const 
{ 
	return get_class<GtkMenuClass>(); 
}

Gtk::Menu::operator GtkMenu* () const
{ 
	return this ? gtk_menu() : 0; 
}
	
Gtk::MenuItem*
Gtk::Menu::get_active() const
{
	return G::Object::wrap<MenuItem>((GtkMenuItem*)gtk_menu_get_active(gtk_menu()));
}

Gtk::AccelGroup*
Gtk::Menu::get_accel_group() const
{
	return G::Object::wrap<AccelGroup>(gtk_menu_get_accel_group(gtk_menu()));
}

Gtk::Widget*
Gtk::Menu::get_attach_widget() const
{
	return G::Object::wrap<Widget>(gtk_menu_get_attach_widget(gtk_menu()));
}

bool 
Gtk::Menu::get_tearoff_state() const
{
	return gtk_menu_get_tearoff_state(gtk_menu());
}

String 
Gtk::Menu::get_title() const
{
	return gtk_menu_get_title(gtk_menu());
}

namespace { // MenuPositionSlot callback

void menu_position_slot_callback(GtkMenu*, gint *x, gint *y, gboolean *push_in, gpointer data)
{
	Gtk::Menu::MenuPositionSlot *slot = static_cast<Gtk::Menu::MenuPositionSlot*>(data);
	bool tmp_push_in = false;
	slot->call(x, y, &tmp_push_in);
	*push_in = tmp_push_in;
}

} // MenuPositionSlot callback	

void 
Gtk::Menu::popup(MenuShell& parent_shell, MenuItem& parent_item, unsigned int button, const MenuPositionSlot *position, unsigned int activate_time)
{
	gtk_menu_popup(gtk_menu(), parent_shell.gtk_widget(), parent_item.gtk_widget(), &menu_position_slot_callback,
	               (void*)position, button, activate_time);
}

void 
Gtk::Menu::popup(unsigned int button, const MenuPositionSlot *position, unsigned int activate_time)
{
	gtk_menu_popup(gtk_menu(), 0, 0, &menu_position_slot_callback, (void*)position, button, activate_time);
}

void 
Gtk::Menu::popup(unsigned int button, unsigned int activate_time)
{
	gtk_menu_popup(gtk_menu(), 0, 0, 0, 0, button, activate_time);
}

void 
Gtk::Menu::reposition()
{
	gtk_menu_reposition(gtk_menu());
}

void 
Gtk::Menu::popdown()
{
	gtk_menu_popdown(gtk_menu());
}

void 
Gtk::Menu::set_active(unsigned int index)
{
	gtk_menu_set_active(gtk_menu(), index);
}

void 
Gtk::Menu::set_accel_group(const AccelGroup *accel_group)
{
	gtk_menu_set_accel_group(gtk_menu(), *accel_group);
}

void
Gtk::Menu::set_accel_path(const char *accel_path)
{
	gtk_menu_set_accel_path(gtk_menu(), accel_path);
}

void
Gtk::Menu::attach_to_widget(Widget& attach_widget)
{
	gtk_menu_attach_to_widget(gtk_menu(), attach_widget.gtk_widget(), &MenuClass::menu_detach_callback);
}

void 
Gtk::Menu::detach()
{
	gtk_menu_detach(gtk_menu());
}

void 
Gtk::Menu::set_tearoff_state(bool torn_off)
{
	gtk_menu_set_tearoff_state(gtk_menu(), torn_off);
} 

void 
Gtk::Menu::set_title(const String& title)
{
	gtk_menu_set_title(gtk_menu(), title.c_str());
}

void
Gtk::Menu::reorder_child(const MenuItem& child, int position)
{
	gtk_menu_reorder_child(gtk_menu(), child.gtk_widget(), position);
}

void 
Gtk::Menu::set_screen(const Gdk::Screen *screen)
{
	gtk_menu_set_screen(gtk_menu(), screen->gdk_screen());
}

/*  Gtk::MenuClass
 */

void
Gtk::MenuClass::init(GtkMenuClass *g_class)
{
	MenuShellClass::init((GtkMenuShellClass*)g_class);
}

GType
Gtk::MenuClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_MENU, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::MenuClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::MenuClass::menu_detach_callback(GtkWidget *widget, GtkMenu *menu)
{
	Menu *tmp_menu = G::Object::pointer<Menu>(menu);
	if (tmp_menu)
		tmp_menu->on_menu_detach(*G::Object::wrap<Gtk::Widget>(widget));
}

/*  Properties
 */

const Gtk::Menu::TearoffTitlePropertyType Gtk::Menu::tearoff_title_property("tearoff-title");

