/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *  Copyright (C) 2000 Red Hat, Inc.
 *  Copyright 1999, Karl Einar Nelson
 *
 *  signals.cc - C++ signal implementation for creating non-GTK signals
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "signals.h"

using namespace Inti;

/*  SlotNode
 */
	
SlotNode::SlotNode(const Slot *slot)
: Node(const_cast<Slot*>(slot)), is_blocked(false)
{
}

SlotNode::~SlotNode()
{
}
	
void 
SlotNode::block()
{
	is_blocked = true;
}
		
void 
SlotNode::unblock()
{ 
	is_blocked = false; 
}

void
SlotNode::disconnect()
{ 
	is_blocked = true; 
}

/*  Signal;
 */

Signal::Signal()
{
}
	
Signal::~Signal()
{
	int count = connection_list.size();
	while (count)
	{
		SlotNode *node = connection_list[count - 1];
		node->unref();
		--count;
	}
	connection_list.clear();
}

SlotNode*
Signal::connect(const Slot *slot)
{
	SlotNode *node = new SlotNode(slot);
	connection_list.push_back(node);
	return node;
}

