use strict;

my $mb_bt_kind = 0;
my $mb_bt_node = $mb_bt_kind++;
my $mb_bt_1 = $mb_bt_kind++;
my $mb_bt_n = $mb_bt_kind++;
my $mb_bt_nkinds = $mb_bt_kind++;
my $mb_bt_failure = $mb_bt_nkinds;

my $bt_prop_len = 8;
my $bt_prop_mask = (1 << $bt_prop_len) - 1;
my $bt_masklen_max = 24;
my $bt_off_minmax = 1 + 2;

my $bt_prop_invalid = ($bt_masklen_max + 1) * $bt_off_minmax * $mb_bt_nkinds;

sub bt_dec_prop_kind ($) {my $enc = shift; ($enc & $bt_prop_mask) % $mb_bt_nkinds}
sub bt_dec_prop_off ($) {my $enc = shift; (($enc & $bt_prop_mask) / $mb_bt_nkinds) % $bt_off_minmax}
sub bt_dec_prop_masklen ($) {my $enc = shift; (($enc & $bt_prop_mask) / $mb_bt_nkinds) / $bt_off_minmax}

sub bt_keymask ($) {my $len = shift; ((1 << $len) - 1) << ($bt_masklen_max - $len)}

sub bt_encode ($$$$) {
  my ($kind, $key, $masklen, $count) = @_;

  $kind == $mb_bt_failure ? $bt_prop_invalid :
    ((($key & &bt_keymask($masklen)) | int($count / $bt_off_minmax)) << $bt_prop_len) |
      ($masklen * $bt_off_minmax * $mb_bt_nkinds + ($count % $bt_off_minmax) * $mb_bt_nkinds + $kind);
}

sub bt_new {[]}
sub bt_whatkind {$_[0]->[$_[1]]->[0]}
sub bt_set_whatkind {$_[0]->[$_[1]]->[0] = $_[2]}
sub bt_masklen {$_[0]->[$_[1]]->[1]}
sub bt_set_masklen {$_[0]->[$_[1]]->[1] = $_[2]}
sub bt_key {$_[0]->[$_[1]]->[2]}
sub bt_set_key {$_[0]->[$_[1]]->[2] = $_[2]}
sub bt_value {$_[0]->[$_[1]]->[3]}
sub bt_set_value {$_[0]->[$_[1]]->[3] = $_[2]}
sub bt_count {$_[0]->[$_[1]]->[4]}
sub bt_set_count {$_[0]->[$_[1]]->[4] = $_[2]}

sub bt_add {
  my ($self, $key, $value) = @_;

  if (@$self) {
    my ($i, $cmp, @unmatch, @match);

  descend:
    for (;;) {
      for ($i = 0 ; $i < 2 ; ++$i) {
	my $kind = &bt_whatkind($self, $i);

	if ($kind != $mb_bt_failure) {
	  my $masklen = &bt_masklen($self, $i);
	  my $mask = &bt_keymask($masklen);
	  my $k = &bt_key($self, $i);

	  if (!($cmp = ($key & $mask) <=> ($k & $mask))) {
	    if ($kind == $mb_bt_node) {
	      @unmatch = @match = ();
	      $self = &bt_value($self, $i);
	      next descend;
	    }

	    &bt_set_value($self, $i, $value);
	    return;
	  }
	  else {
	    push(@unmatch, $cmp);

	    for (; $masklen > 0 ; --$masklen) {
	      $mask = &bt_keymask($masklen);

	      if (($key & $mask) == ($k & $mask)) {
		push(@match, $masklen);
		last;
	      }
	    }

	    push(@match, 0) unless ($masklen > 0);
	  }
	}
      }

      last descend;
    }

    if (@unmatch < 2) {
      my $new = 1;

      if ($unmatch[0] < 0) {
	@{$self}[0, 1] = @{$self}[1, 0];
	$new = 0;
      }

      &bt_set_whatkind($self, $new, $mb_bt_1);
      &bt_set_masklen($self, $new, $bt_masklen_max);
      &bt_set_key($self, $new, $key);
      &bt_set_value($self, $new, $value);
      return;
    }

    my $hit = $match[0] > $match[1] ? 0 : 1;
    my ($new, $old) = $unmatch[$hit] < 0 ? (0, 1) : (1, 0);
    my $newnode = &bt_new;

    &bt_set_whatkind($newnode, $old, &bt_whatkind($self, $hit));
    &bt_set_masklen($newnode, $old, &bt_masklen($self, $hit));
    &bt_set_key($newnode, $old, &bt_key($self, $hit));
    &bt_set_value($newnode, $old, &bt_value($self, $hit));
    &bt_set_whatkind($newnode, $new, $mb_bt_1);
    &bt_set_masklen($newnode, $new, $bt_masklen_max);
    &bt_set_key($newnode, $new, $key);
    &bt_set_value($newnode, $new, $value);
    &bt_set_whatkind($self, $hit, $mb_bt_node);
    &bt_set_masklen($self, $hit, $match[$hit]);
    &bt_set_key($self, $hit, $key & &bt_keymask($match[$hit]));
    &bt_set_value($self, $hit, $newnode);
  }
  else {
    &bt_set_whatkind($self, 0, $mb_bt_1);
    &bt_set_masklen($self, 0, $bt_masklen_max);
    &bt_set_key($self, 0, $key);
    &bt_set_value($self, 0, $value);
    &bt_set_whatkind($self, 1, $mb_bt_failure);
  }
}

sub bt_optimize {
  my $self = shift;

  if (@$self) {
    my $lkind = &bt_whatkind($self, 0);
    my $lkey = &bt_key($self, 0);
    my $lofflen = $bt_masklen_max - &bt_masklen($self, 0);
    my $lval = &bt_value($self, 0);
    my $lcount = $lkind == $mb_bt_failure ? 0 : 1;
    my $rkind = &bt_whatkind($self, 1);
    my $rkey = &bt_key($self, 1);
    my $rofflen = $bt_masklen_max - &bt_masklen($self, 1);
    my $rval = &bt_value($self, 1);
    my $rcount = $rkind == $mb_bt_failure ? 0 : 1;

    ($lkind, $lval, $lcount) = &bt_optimize($lval) if ($lkind == $mb_bt_node);
    ($rkind, $rval, $rcount) = &bt_optimize($rval) if ($rkind == $mb_bt_node);
    &bt_set_whatkind($self, 0, $lkind);
    &bt_set_value($self, 0, $lval);
    &bt_set_count($self, 0, $lcount);
    &bt_set_whatkind($self, 1, $rkind);
    &bt_set_value($self, 1, $rval);
    &bt_set_count($self, 1, $rcount);

    if ($lofflen == $rofflen && $rkind == $lkind && $rkey == $lkey + (1 << $lofflen) &&
	(($rkind == $mb_bt_1 && ($rval == $lval || (!$rofflen && !$lofflen && $rval == $lval + 1))) ||
	 ($rkind == $mb_bt_n && $rval == $lval + (1 << $lofflen)))) {
      return ($lval == $rval ? $mb_bt_1 : $mb_bt_n, $lval, 1);
    }
    else {
      ($mb_bt_node, $self, 2 + $lcount + $rcount);
    }
  }
}

sub bt_print_c_source {
  my ($self, $glob) = @_;

  if (@$self) {
    my $lkind = &bt_whatkind($self, 0);
    my $lkey = &bt_key($self, 0);
    my $lmasklen = &bt_masklen($self, 0);
    my $lval = &bt_value($self, 0);
    my $lcount = &bt_count($self, 0);
    my $rkind = &bt_whatkind($self, 1);
    my $rkey = &bt_key($self, 1);
    my $rmasklen = &bt_masklen($self, 1);
    my $rval = &bt_value($self, 1);
    my $rcount = &bt_count($self, 1);

    printf $glob ("0x%X,/*0*/\n0x%X,/*1*/\n",
		  &bt_encode($lkind, $lkey, $lmasklen, $lcount),
		  &bt_encode($rkind, $rkey, $rmasklen, $rcount));

    if ($lkind == $mb_bt_node) {
      &bt_print_c_source($lval, $glob);
    }
    elsif ($lkind == $mb_bt_1 || $lkind == $mb_bt_n) {
      printf $glob "0x%X,\n", $lval;
    }

    if ($rkind == $mb_bt_node) {
      &bt_print_c_source($rval, $glob);
    }
    elsif ($rkind == $mb_bt_1 || $rkind == $mb_bt_n) {
      printf $glob "0x%X,\n", $rval;
    }
  }
}

sub bt_make_c_header {
  my ($self, $fn) = @_;
  local (*H);

  open(H, ">$fn") || return undef;
  print H '/* ' . $fn . ': generated by ' . $0 . ' at ' . gmtime(time) . " GMT */\n";
  &bt_print_c_source($self, \*H);
  close(H);
  1;
}

sub bt_kind2str {
  my $kind = shift;

  if ($kind == $mb_bt_node) {
    "node";
  }
  elsif ($kind == $mb_bt_1) {
    "single value";
  }
  elsif ($kind == $mb_bt_n) {
    "multiple value";
  }
  else {
    "invalid";
  }
}

sub bt_dump {
  my ($self, $glob) = @_;

  $glob = \*STDERR if (!defined($glob));

  if (@$self) {
    my $lkind = &bt_whatkind($self, 0);
    my $lkey = &bt_key($self, 0);
    my $lmasklen = &bt_masklen($self, 0);
    my $lval = &bt_value($self, 0);
    my $lcount = &bt_count($self, 0);
    my $rkind = &bt_whatkind($self, 1);
    my $rkey = &bt_key($self, 1);
    my $rmasklen = &bt_masklen($self, 1);
    my $rval = &bt_value($self, 1);
    my $rcount = &bt_count($self, 1);

    printf $glob ("left: whatkind==%s, key==0x%X, makslen==%d, count==%d\n" .
		  "right: whatkind==%s, key==0x%X, makslen==%d, count==%d\n",
		  &bt_kind2str($lkind), $lkey, $lmasklen, $lcount,
		  &bt_kind2str($rkind), $rkey, $rmasklen, $rcount);

    if ($lkind == $mb_bt_node) {
      &bt_dump($lval, $glob);
    }
    elsif ($lkind == $mb_bt_1 || $lkind == $mb_bt_n) {
      printf $glob "value: 0x%X\n", $lval;
    }

    if ($rkind == $mb_bt_node) {
      &bt_dump($rval, $glob);
    }
    elsif ($rkind == $mb_bt_1 || $rkind == $mb_bt_n) {
      printf $glob "value: 0x%X\n", $rval;
    }
  }
}

1;
